/*
 * Decompiled with CFR 0.152.
 */
package com.jtransc.crypto;

import com.jtransc.JTranscSystem;
import com.jtransc.annotation.JTranscMethodBody;
import com.jtransc.annotation.haxe.HaxeMethodBody;
import com.jtransc.annotation.haxe.HaxeMethodBodyList;
import com.jtransc.annotation.haxe.HaxeMethodBodyPost;
import com.jtransc.annotation.haxe.HaxeMethodBodyPre;
import java.security.SecureRandom;

public class JTranscCrypto {
    public static SecureRandomProvider secureRandomProvider = new SecureRandomProvider(){};

    public static void fillSecureRandomBytes(byte[] data) {
        if (secureRandomProvider == null || data == null) {
            throw new RuntimeException("fillSecureRandomBytes");
        }
        secureRandomProvider.fillSecureRandomBytes(data);
    }

    public static byte[] md5(byte[] data) {
        throw new RuntimeException("Not implemented md5 yet!");
    }

    public static byte[] sha1(byte[] data) {
        throw new RuntimeException("Not implemented sha1 yet!");
    }

    public static class SecureRandomProvider {
        @HaxeMethodBodyPre(value="var bytes = p0;\nvar length = bytes.length;\n\n")
        @HaxeMethodBodyList(value={@HaxeMethodBody(target="js", value="try {\n  var _bytes = bytes.data;\n  untyped __js__(\"crypto.getRandomValues(_bytes);\");\n  return;\n} catch (e:Dynamic) {\n\n}\n"), @HaxeMethodBody(value="")})
        @HaxeMethodBodyPost(value="for (n in 0 ... length) {\n  bytes.set(n, Std.int(Math.random() * 255));\n}")
        @JTranscMethodBody(target="js", value={"N.fillSecureRandomBytes(p0);"})
        public void fillSecureRandomBytes(byte[] data) {
            if (!JTranscSystem.isJTransc()) {
                SecureRandom secureRandom = new SecureRandom();
                secureRandom.nextBytes(data);
            } else {
                System.err.println("[IMPORTANT WARNING] Using SecureRandom without properly setting JTranscCrypto.secureRandomProvider");
            }
        }
    }
}

