/*
 * Decompiled with CFR 0.152.
 */
package com.jtransc.io;

import com.jtransc.io.JTranscConsole;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;

public class JTranscConsolePrintStream
extends PrintStream {
    final boolean error;
    final ConsoleOutputStream stream;

    public JTranscConsolePrintStream(boolean error) {
        this(new ConsoleOutputStream(error), error);
    }

    private JTranscConsolePrintStream(ConsoleOutputStream stream, boolean error) {
        super(stream);
        this.stream = stream;
        this.error = error;
    }

    @Override
    public void println(String x) {
        JTranscConsole.logOrError(this.stream.sb.toString() + x, this.error);
        this.stream.sb.setLength(0);
    }

    private static class ConsoleOutputStream
    extends OutputStream {
        public StringBuilder sb = new StringBuilder();
        private final boolean error;

        public ConsoleOutputStream(boolean error) {
            this.error = error;
        }

        @Override
        public void write(int b) throws IOException {
            char c = (char)b;
            if (c == '\n') {
                JTranscConsole.logOrError(this.sb.toString(), this.error);
                this.sb.setLength(0);
            } else {
                this.sb.append(c);
            }
        }
    }
}

