/*
 * Decompiled with CFR 0.152.
 */
package com.jtransc;

import com.jtransc.JTranscSystemProperties;
import com.jtransc.annotation.JTranscMethodBody;
import com.jtransc.annotation.JTranscMethodBodyList;
import com.jtransc.annotation.haxe.HaxeMethodBody;
import com.jtransc.annotation.haxe.HaxeMethodBodyList;
import com.jtransc.target.Js;
import com.jtransc.time.JTranscClock;

public class JTranscSystem {
    private static final boolean TRUE = true;
    private static final boolean FALSE = false;
    static double start = -1.0;

    public static double fastTime() {
        return JTranscClock.impl.fastTime();
    }

    public static long nanoTime() {
        return JTranscClock.impl.nanoTime();
    }

    public static void sleep(double ms) {
        JTranscClock.impl.sleep(ms);
    }

    public static double stamp() {
        if (start < 0.0) {
            start = JTranscSystem.fastTime();
        }
        return JTranscSystem.elapsedTime(start, JTranscSystem.fastTime());
    }

    public static int elapsedTime(int first, int second) {
        return second - first;
    }

    public static double elapsedTime(double first, double second) {
        return second - first;
    }

    @JTranscMethodBody(target="js", value={""})
    @HaxeMethodBodyList(value={@HaxeMethodBody(target="cpp", value="cpp.vm.Gc.enable(false);"), @HaxeMethodBody(target="d", value=""), @HaxeMethodBody(value="")})
    public static void gcDisable() {
    }

    @JTranscMethodBody(target="js", value={""})
    @HaxeMethodBodyList(value={@HaxeMethodBody(value=""), @HaxeMethodBody(target="cpp", value="cpp.vm.Gc.enable(true);"), @HaxeMethodBody(target="d", value="")})
    public static void gcEnable() {
    }

    @JTranscMethodBody(target="js", value={""})
    @HaxeMethodBodyList(value={@HaxeMethodBody(value=""), @HaxeMethodBody(target="cpp", value="cpp.vm.Gc.compact();"), @HaxeMethodBody(target="d", value=""), @HaxeMethodBody(target="cs", value="System.GC.Collect()")})
    public static void gc() {
        System.gc();
    }

    @HaxeMethodBody(value="return true;")
    @JTranscMethodBodyList(value={@JTranscMethodBody(target="js", value={"return true;"}), @JTranscMethodBody(target="cpp", value={"return true;"}), @JTranscMethodBody(target="d", value={"return true;"}), @JTranscMethodBody(target="cs", value={"return true;"}), @JTranscMethodBody(target="as3", value={"return true;"}), @JTranscMethodBody(target="dart", value={"return true;"})})
    public static boolean usingJTransc() {
        return false;
    }

    public static boolean isJTransc() {
        return JTranscSystem.usingJTransc();
    }

    @HaxeMethodBody(value="N.debugger();")
    @JTranscMethodBodyList(value={@JTranscMethodBody(target="js", value={"debugger;"}), @JTranscMethodBody(target="cs", value={"System.Diagnostics.Debugger.Break();"})})
    public static void debugger() {
    }

    @HaxeMethodBody(value="if (!p0) N.debugger();")
    @JTranscMethodBodyList(value={@JTranscMethodBody(target="js", value={"if (!p0) debugger;"}), @JTranscMethodBody(target="cs", value={"if (!pc) System.Diagnostics.Debugger.Break();"})})
    public static void assert2(boolean trueCond) {
        if (!trueCond) {
            System.out.println("debugger");
            throw new Error("Debugger");
        }
    }

    @JTranscMethodBodyList(value={@JTranscMethodBody(target="js", value={"return N.str(\"js\");"}), @JTranscMethodBody(target="cpp", value={"return N::str(L\"cpp\");"}), @JTranscMethodBody(target="d", value={"return N.str(\"d\");"}), @JTranscMethodBody(target="cs", value={"return N.str(\"csharp\");"})})
    public static String getRuntimeKind() {
        if (!JTranscSystem.usingJTransc()) {
            return "java";
        }
        if (JTranscSystem.isHaxe()) {
            if (JTranscSystem.isJs()) {
                return "haxe-js";
            }
            if (JTranscSystem.isAs3()) {
                return "haxe-as3";
            }
            if (JTranscSystem.isNeko()) {
                return "haxe-neko";
            }
            if (JTranscSystem.isCpp()) {
                return "haxe-cpp";
            }
            return "haxe";
        }
        if (JTranscSystem.isSwf()) {
            return "swf";
        }
        if (JTranscSystem.isJvm()) {
            return "java";
        }
        if (JTranscSystem.isCsharp()) {
            return "csharp";
        }
        if (JTranscSystem.isNeko()) {
            return "neko";
        }
        if (JTranscSystem.isPhp()) {
            return "php";
        }
        if (JTranscSystem.isPython()) {
            return "python";
        }
        if (JTranscSystem.isAs3()) {
            return "as3";
        }
        if (JTranscSystem.isDart()) {
            return "dart";
        }
        if (JTranscSystem.isCpp()) {
            return "cpp";
        }
        return "unknown";
    }

    @HaxeMethodBody(value="return true;")
    public static boolean isHaxe() {
        return false;
    }

    @JTranscMethodBody(target="js", value={"return true;"})
    public static boolean isPureJs() {
        return false;
    }

    @HaxeMethodBodyList(value={@HaxeMethodBody(target="sys", value="return true;"), @HaxeMethodBody(value="return false;")})
    @JTranscMethodBodyList(value={@JTranscMethodBody(target="js", value={"return false;"}), @JTranscMethodBody(target="cpp", value={"return true;"}), @JTranscMethodBody(target="cs", value={"return true;"})})
    public static boolean isSys() {
        return true;
    }

    @JTranscMethodBody(target="cpp", value={"return true;"})
    public static boolean isCpp() {
        return false;
    }

    @JTranscMethodBody(target="d", value={"return true;"})
    public static boolean isD() {
        return false;
    }

    @HaxeMethodBodyList(value={@HaxeMethodBody(target="cs", value="return true;"), @HaxeMethodBody(value="return false;")})
    @JTranscMethodBody(target="cs", value={"return true;"})
    public static boolean isCsharp() {
        return false;
    }

    public static boolean isJvm() {
        return !JTranscSystem.isJTransc();
    }

    public static boolean isJava() {
        return JTranscSystem.isJvm();
    }

    @HaxeMethodBodyList(value={@HaxeMethodBody(target="js", value="return true;"), @HaxeMethodBody(value="return false;")})
    @JTranscMethodBody(target="js", value={"return true;"})
    public static boolean isJs() {
        return false;
    }

    public static boolean isJsNode() {
        if (JTranscSystem.isJs()) {
            return Js.z_raw("(typeof module !== 'undefined' && module.exports) != false");
        }
        return false;
    }

    public static boolean isJsBrowser() {
        if (JTranscSystem.isJs()) {
            return Js.z_raw("typeof window != \"undefined\"");
        }
        return false;
    }

    @HaxeMethodBody(target="flash", value="return true;")
    public static boolean isSwf() {
        return false;
    }

    @HaxeMethodBody(target="neko", value="return true;")
    public static boolean isNeko() {
        return false;
    }

    @HaxeMethodBody(target="php", value="return true;")
    public static boolean isPhp() {
        return false;
    }

    @HaxeMethodBody(target="python", value="return true;")
    public static boolean isPython() {
        return false;
    }

    @JTranscMethodBody(target="as3", value={"return true;"})
    public static boolean isAs3() {
        return false;
    }

    @JTranscMethodBody(target="dart", value={"return true;"})
    public static boolean isDart() {
        return false;
    }

    @HaxeMethodBodyList(value={@HaxeMethodBody(target="sys", value="return N.str(Sys.systemName());"), @HaxeMethodBody(target="js", value="return N.str(untyped __js__(\"(typeof navigator != 'undefined' ? navigator.platform : process.platform)\"));"), @HaxeMethodBody(value="return N.str('unknown');")})
    @JTranscMethodBodyList(value={@JTranscMethodBody(target="js", value={"return N.str(typeof navigator != 'undefined' ? navigator.platform : process.platform);"}), @JTranscMethodBody(target="cpp", value={"return N::str(L\"unknown\");"}), @JTranscMethodBody(target="d", value={"return N.str(N.getOS());"}), @JTranscMethodBody(target="cs", value={"return N.str(System.Environment.OSVersion.Platform.ToString());"}), @JTranscMethodBody(target="as3", value={"return N.str('as3');"}), @JTranscMethodBody(target="dart", value={"return N.str(Platform.operatingSystem);"})})
    private static String getOSRaw() {
        if (JTranscSystem.isJTransc()) {
            throw new RuntimeException("getOSRaw()");
        }
        return System.getProperty("os.name");
    }

    public static String getOS() {
        String os = JTranscSystem.getOSRaw().toLowerCase();
        if (os.startsWith("win")) {
            return "windows";
        }
        if (os.startsWith("lin")) {
            return "linux";
        }
        if (os.startsWith("mac") || os.startsWith("osx")) {
            return "mac";
        }
        if (os.startsWith("fuch")) {
            return "fuchsia";
        }
        return os;
    }

    @HaxeMethodBody(value="return N.str('x86');")
    @JTranscMethodBodyList(value={@JTranscMethodBody(target="js", value={"return N.str('x86');"}), @JTranscMethodBody(target="cpp", value={"return N::str(L\"x86\");"})})
    public static String getArch() {
        if (JTranscSystem.isJvm()) {
            return System.getProperty("os.arch");
        }
        return "unknown";
    }

    public static boolean isOs32() {
        return !JTranscSystem.isOs64();
    }

    public static boolean isOs64() {
        if (System.getProperty("os.name").contains("Windows")) {
            return System.getenv("ProgramFiles(x86)") != null;
        }
        return System.getProperty("os.arch").contains("64");
    }

    public static boolean isFuchsia() {
        return JTranscSystem.getOS().toLowerCase().startsWith("fuch");
    }

    public static boolean isWindows() {
        return JTranscSystem.getOS().toLowerCase().startsWith("win");
    }

    public static boolean isLinux() {
        return JTranscSystem.getOS().toLowerCase().startsWith("linux");
    }

    public static boolean isMac() {
        return JTranscSystem.getOS().toLowerCase().startsWith("mac");
    }

    public static boolean isPosix() {
        return !JTranscSystem.isWindows();
    }

    public static boolean isNotWindows() {
        return !JTranscSystem.isWindows();
    }

    public static String getTimeZone() {
        return "GMT";
    }

    @HaxeMethodBody(target="debug", value="return true;")
    @JTranscMethodBodyList(value={@JTranscMethodBody(target="js", value={"return true;"}), @JTranscMethodBody(target="d", value={"debug { return true; } return false;"})})
    public static boolean isDebug() {
        return false;
    }

    @HaxeMethodBody(value="return N.str('jtransc-haxe');")
    @JTranscMethodBodyList(value={@JTranscMethodBody(target="js", value={"return N.str('jtransc-js');"}), @JTranscMethodBody(target="cpp", value={"return N::str(L\"jtransc-cpp\");"}), @JTranscMethodBody(target="d", value={"return N.str(\"jtransc-d\");"})})
    public static String getRuntimeName() {
        return "java";
    }

    @HaxeMethodBody(value="return N.str('/jtransc-haxe');")
    @JTranscMethodBodyList(value={@JTranscMethodBody(target="js", value={"return N.str('/jtransc-js');"}), @JTranscMethodBody(target="cpp", value={"return N::str(L\"/\");"}), @JTranscMethodBody(target="d", value={"return N.str(\"/\");"})})
    public static String getJavaHome() {
        return System.getenv("java.home");
    }

    @JTranscMethodBodyList(value={@JTranscMethodBody(target="js", value={"return true;"}), @JTranscMethodBody(target="php", value={"return true;"}), @JTranscMethodBody(target="as3", value={"return true;"})})
    public static boolean isEmulatedLong() {
        return false;
    }

    public static String fileSeparator() {
        return JTranscSystemProperties.fileSeparator();
    }

    public static String pathSeparator() {
        return JTranscSystemProperties.pathSeparator();
    }

    public static String lineSeparator() {
        return JTranscSystemProperties.lineSeparator();
    }

    public static String getUserHome() {
        return JTranscSystemProperties.userHome();
    }

    public static void checkInJVM(String reason) {
        if (JTranscSystem.isJTransc()) {
            throw new RuntimeException("Not expected JTransc: " + reason);
        }
    }

    public static boolean hasEventLoop() {
        return JTranscSystem.isDart() || JTranscSystem.isJs() || JTranscSystem.isAs3();
    }
}

