/*
 * Decompiled with CFR 0.152.
 */
package com.jtransc.io.async;

import com.jtransc.async.JTranscAsyncHandler;
import com.jtransc.io.JTranscFileMode;
import com.jtransc.io.JTranscFileStat;
import com.jtransc.io.async.JTranscAsyncFileSystem;
import com.jtransc.io.async.JTranscAsyncStream;
import java.util.Arrays;

public class JTranscAsyncFile {
    public String path;

    public JTranscAsyncFile(String path) {
        this.path = path;
    }

    private static JTranscAsyncFileSystem fs() {
        return JTranscAsyncFileSystem.getInstance();
    }

    public void getLengthAsync(JTranscAsyncHandler<Long> handler) {
        JTranscAsyncFile.fs().getLength(this.path, handler);
    }

    public void mkdirAsync(JTranscAsyncHandler<Boolean> handler) {
        JTranscAsyncFile.fs().mkdir(this.path, handler);
    }

    public void statAsync(JTranscAsyncHandler<JTranscFileStat> handler) {
        JTranscAsyncFile.fs().stat(this.path, handler);
    }

    public void openAsync(JTranscFileMode mode, JTranscAsyncHandler<JTranscAsyncStream> handler) {
        JTranscAsyncFile.fs().open(this.path, mode, handler);
    }

    public void readAllAsync(final JTranscAsyncHandler<byte[]> handler) {
        this.openAsync(JTranscFileMode.READ, new JTranscAsyncHandler<JTranscAsyncStream>(){

            @Override
            public void complete(final JTranscAsyncStream asyncStream, Throwable error) {
                if (error != null) {
                    handler.complete(null, error);
                } else {
                    asyncStream.getLengthAsync(new JTranscAsyncHandler<Long>(){

                        @Override
                        public void complete(Long value, Throwable error) {
                            if (error != null) {
                                handler.complete(null, error);
                            } else {
                                final byte[] data = new byte[value.intValue()];
                                asyncStream.readAsync(0L, data, 0, data.length, new JTranscAsyncHandler<Integer>(){

                                    @Override
                                    public void complete(Integer value, Throwable error) {
                                        if (error != null) {
                                            handler.complete(null, error);
                                        } else {
                                            handler.complete(Arrays.copyOf(data, (int)value), null);
                                        }
                                    }
                                });
                            }
                        }
                    });
                }
            }
        });
    }
}

