/*
 * Decompiled with CFR 0.152.
 */
package com.jtransc.text;

import com.jtransc.annotation.JTranscInvisible;

@JTranscInvisible
public class MStringReader {
    public final String str;
    public final int length;
    public int offset;

    public MStringReader(String str) {
        this(str, 0);
    }

    public MStringReader(String str, int offset) {
        this.str = str;
        this.length = str.length();
        this.offset = offset;
    }

    public boolean hasMore() {
        return this.offset < this.length;
    }

    public char peek() {
        if (!this.hasMore()) {
            throw new Error("Can't read more");
        }
        return this.str.charAt(this.offset);
    }

    public void skip() {
        this.skip(1);
    }

    public void skip(int count) {
        this.offset += count;
    }

    public void expect(char c) {
        if (this.read() != c) {
            throw new Error("Expected " + c);
        }
    }

    public char read() {
        if (!this.hasMore()) {
            throw new Error("Can't read more");
        }
        char out = this.peek();
        this.skip();
        return out;
    }
}

