/*
 * Decompiled with CFR 0.152.
 */
package com.jtransc.util;

import com.jtransc.JTranscBits;
import com.jtransc.annotation.JTranscInvisible;

@JTranscInvisible
public class JTranscStrings {
    public static String substr(String subject, int offset) {
        return JTranscStrings.substr(subject, offset, Integer.MAX_VALUE);
    }

    public static String substr(String subject, int offset, int count) {
        int subjectLen = subject.length();
        int realStart = offset < 0 ? JTranscBits.clamp(JTranscBits.unsignedMod(offset, subjectLen), 0, subjectLen) : JTranscBits.clamp(offset, 0, subjectLen);
        int realEnd = count < 0 ? JTranscBits.unsignedMod(subjectLen + count, subjectLen) : JTranscBits.clamp(realStart + count, 0, subjectLen);
        return subject.substring(realStart, realEnd);
    }

    public static String[] splitInChunks(String subject, int count) {
        return JTranscStrings.splitInChunksDirection(subject, count);
    }

    public static String[] splitInChunksRightToLeft(String subject, int count) {
        return JTranscStrings.splitInChunksDirection(subject, -count);
    }

    public static String[] splitInChunksDirection(String subject, int count) {
        boolean leftToRight = count > 0;
        int slen = subject.length();
        int acount = Math.abs(count);
        double dpartCount = Math.ceil((double)subject.length() / (double)acount);
        int partCount = (int)Math.ceil((double)subject.length() / (double)acount);
        String[] out = new String[partCount];
        for (int n = 0; n < partCount; ++n) {
            int pos = leftToRight ? n * acount : subject.length() - (n + 1) * acount;
            int index = leftToRight ? n : partCount - n - 1;
            int len = acount;
            if (pos < 0) {
                len += pos;
                pos = 0;
            }
            int end = Math.min(slen, pos + len);
            out[index] = subject.substring(pos, end);
        }
        return out;
    }

    public static String join(String[] parts) {
        int count = 0;
        for (String part : parts) {
            count += part.length();
        }
        StringBuilder out = new StringBuilder(count);
        for (String part : parts) {
            out.append(part);
        }
        return out.toString();
    }

    public static String join(String[] parts, String separator) {
        if (parts.length == 0) {
            return "";
        }
        int count = 0;
        for (String part : parts) {
            count += part.length();
        }
        StringBuilder out = new StringBuilder(count += (parts.length - 1) * separator.length());
        for (int n = 0; n < parts.length; ++n) {
            if (n != 0) {
                out.append(separator);
            }
            out.append(parts[n]);
        }
        return out.toString();
    }
}

