/*
 * Decompiled with CFR 0.152.
 */
package j;

import com.jtransc.ds.FastIntMap;
import com.jtransc.ds.FastStringMap;
import j.ClassInfo;
import j.MemberInfo;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;

public class ProgramReflection {
    public static ClassInfo[] _classInfos;
    public static String[] _classNames;
    public static FastStringMap<ClassInfo> _classInfosByName;
    public static FastIntMap<FastIntMap<MemberInfo>> _constructorsInfo;
    public static FastIntMap<FastIntMap<MemberInfo>> _methodInfos;
    public static FastIntMap<FastIntMap<MemberInfo>> _fieldsInfos;

    public static void _ensure() {
        if (_classInfos != null) {
            return;
        }
        _classInfosByName = new FastStringMap();
        _classInfos = ProgramReflection.getAllClasses();
        if (_classInfos != null) {
            _classNames = new String[_classInfos.length];
            for (ClassInfo info : _classInfos) {
                if (info == null) continue;
                _classInfosByName.set(info.name, info);
                ProgramReflection._classNames[info.id] = info.name;
            }
        }
    }

    public static void _ensureConstructors() {
        if (_constructorsInfo != null) {
            return;
        }
        ProgramReflection._ensure();
        _constructorsInfo = new FastIntMap();
        for (ClassInfo info : _classInfos) {
            if (info == null) continue;
            FastIntMap<MemberInfo> map = new FastIntMap<MemberInfo>();
            _constructorsInfo.set(info.id, map);
            MemberInfo[] minfo = ProgramReflection.getConstructors(info.id);
            if (minfo == null) continue;
            for (MemberInfo i : minfo) {
                map.set(i.id, i);
            }
        }
    }

    public static void _ensureFields() {
        if (_fieldsInfos != null) {
            return;
        }
        ProgramReflection._ensure();
        _fieldsInfos = new FastIntMap();
        for (ClassInfo info : _classInfos) {
            if (info == null) continue;
            FastIntMap<MemberInfo> map = new FastIntMap<MemberInfo>();
            _fieldsInfos.set(info.id, map);
            MemberInfo[] minfo = ProgramReflection.getFields(info.id);
            if (minfo == null) continue;
            for (MemberInfo i : minfo) {
                map.set(i.id, i);
            }
        }
    }

    public static void _ensureMethods() {
        if (_methodInfos != null) {
            return;
        }
        ProgramReflection._ensure();
        _methodInfos = new FastIntMap();
        for (ClassInfo info : _classInfos) {
            if (info == null) continue;
            FastIntMap<MemberInfo> map = new FastIntMap<MemberInfo>();
            _methodInfos.set(info.id, map);
            MemberInfo[] minfo = ProgramReflection.getMethods(info.id);
            if (minfo == null) continue;
            for (MemberInfo i : minfo) {
                map.set(i.id, i);
            }
        }
    }

    public static boolean hasClassWithName(String name) {
        ProgramReflection._ensure();
        return _classInfosByName.has(name);
    }

    public static ClassInfo getClassInfoWithName(String name) {
        ProgramReflection._ensure();
        return ProgramReflection.hasClassWithName(name) ? _classInfosByName.get(name) : null;
    }

    public static ClassInfo[] getAllClasses() {
        return _classInfos != null ? _classInfos : AllClasses.getAllClasses();
    }

    public static MemberInfo[] getConstructors(int classId) {
        return AllConstructors.getConstructors(classId);
    }

    public static MemberInfo[] getMethods(int classId) {
        return AllMethods.getMethods(classId);
    }

    public static MemberInfo[] getFields(int classId) {
        return AllFields.getFields(classId);
    }

    public static Object dynamicNew(int classId, int constructorId, Object[] params) {
        return DynamicNewInvoke.dynamicNew(classId, constructorId, params);
    }

    public static Object dynamicInvoke(int classId, int methodId, Object object, Object[] params) {
        return DynamicNewInvoke.dynamicInvoke(classId, methodId, object, params);
    }

    public static Object dynamicGet(int classId, int fieldId, Object object) {
        return DynamicGetSet.dynamicGet(classId, fieldId, object);
    }

    public static void dynamicSet(int classId, int fieldId, Object object, Object value) {
        DynamicGetSet.dynamicSet(classId, fieldId, object, value);
    }

    public static Annotation[] getClassAnnotations(int classId) {
        return new Annotation[0];
    }

    public static Annotation[] getFieldAnnotations(int classId, int fieldId) {
        return new Annotation[0];
    }

    public static Annotation[] getMethodAnnotations(int classId, int methodId) {
        return new Annotation[0];
    }

    public static Annotation[] getMethodArgumentAnnotations(int classId, int methodId, int argIndex) {
        return new Annotation[0];
    }

    public static MemberInfo getMethodInfo(int classId, int methodId) {
        ProgramReflection._ensureMethods();
        return _methodInfos.get(classId).get(methodId);
    }

    public static native Method getMethodByInfo(Class<?> var0, MemberInfo var1);

    public static Class<?> getClassById(int classId) {
        ProgramReflection._ensure();
        try {
            return Class.forName(_classNames[classId]);
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Method getDirectMethod(int classId, int methodId) {
        return ProgramReflection.getMethodByInfo(ProgramReflection.getClassById(classId), ProgramReflection.getMethodInfo(classId, methodId));
    }

    public static class DynamicGetSet {
        public static Object dynamicGet(int classId, int fieldId, Object object) {
            return null;
        }

        public static void dynamicSet(int classId, int fieldId, Object object, Object value) {
        }
    }

    public static class DynamicNewInvoke {
        public static Object dynamicNew(int classId, int constructorId, Object[] params) {
            return null;
        }

        public static Object dynamicInvoke(int classId, int methodId, Object object, Object[] params) {
            return null;
        }
    }

    public static class AllFields {
        public static MemberInfo[] getFields(int classId) {
            return new MemberInfo[0];
        }
    }

    public static class AllMethods {
        public static MemberInfo[] getMethods(int classId) {
            return new MemberInfo[0];
        }
    }

    public static class AllConstructors {
        public static MemberInfo[] getConstructors(int classId) {
            return new MemberInfo[0];
        }
    }

    public static class AllClasses {
        public static ClassInfo[] getAllClasses() {
            return new ClassInfo[0];
        }
    }
}

