/*
 * Decompiled with CFR 0.152.
 */
package com.jtransc;

import com.jtransc.JTranscSystem;
import com.jtransc.annotation.JTranscAddMembers;
import com.jtransc.annotation.JTranscInline;
import com.jtransc.annotation.JTranscInvisible;
import com.jtransc.annotation.JTranscMethodBody;
import com.jtransc.annotation.JTranscMethodBodyList;
import com.jtransc.annotation.haxe.HaxeAddMembers;
import com.jtransc.annotation.haxe.HaxeMethodBody;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.CharBuffer;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import java.nio.ShortBuffer;

@JTranscInvisible
@HaxeAddMembers(value={"public var _length:Int;", "public var _data:haxe.io.Bytes;", "public var shortData:haxe.io.UInt16Array;", "public var intData:haxe.io.Int32Array;", "public var floatData:haxe.io.Float32Array;", "public var doubleData:haxe.io.Float64Array;", "public function getBytes():haxe.io.Bytes return _data;"})
@JTranscAddMembers(target="cpp", value={"void *vptr;"})
public final class FastMemory {
    private int length;
    private ByteBuffer data;
    private CharBuffer dataChar;
    private ShortBuffer dataShort;
    private IntBuffer dataInt;
    private LongBuffer dataLong;
    private FloatBuffer dataFloat;
    private DoubleBuffer dataDouble;

    private FastMemory(int size) {
        this._initWithSize(size);
        this._createViews();
        if (JTranscSystem.isCpp()) {
            this._createViewsExtra(this.data.array());
        }
    }

    private FastMemory(byte[] data) {
        if (data.length % 8 != 0) {
            throw new RuntimeException("ByteArray must be multiple of 8!");
        }
        this._initWithBytes(data);
        this._createViews();
        if (JTranscSystem.isCpp()) {
            this._createViewsExtra(this.data.array());
        }
    }

    @HaxeMethodBody(value="return null;")
    @JTranscMethodBody(target="js", value={"return null;"})
    public ByteBuffer getByteBufferOrNull() {
        return this.data;
    }

    @HaxeMethodBody(value="this._length = p0.length; this._data = p0.getBytes();")
    @JTranscMethodBody(target="js", value={"this._length = p0.length; this.buffer = p0.data.buffer;"})
    private void _initWithBytes(byte[] data) {
        this.length = data.length;
        this.data = ByteBuffer.wrap(data).order(ByteOrder.nativeOrder());
    }

    @HaxeMethodBody(value="this._length = p0; this._data = haxe.io.Bytes.alloc((p0 + 7) & ~7);")
    @JTranscMethodBody(target="js", value={"this._length = p0; this.buffer = new ArrayBuffer((this._length + 7) & ~7);"})
    private void _initWithSize(int size) {
        this.length = size;
        this.data = ByteBuffer.allocateDirect(size + 15 & 0xFFFFFFF0).order(ByteOrder.nativeOrder());
    }

    @HaxeMethodBody(value="this.shortData = haxe.io.UInt16Array.fromBytes(this._data);\nthis.intData = haxe.io.Int32Array.fromBytes(this._data);\nthis.floatData = haxe.io.Float32Array.fromBytes(this._data);\nthis.doubleData = haxe.io.Float64Array.fromBytes(this._data);\n")
    @JTranscMethodBody(target="js", value={"this.view   = new DataView(this.buffer);", "this.s8     = new Int8Array(this.buffer);", "this.u8     = new Uint8Array(this.buffer);", "this.s16    = new Int16Array(this.buffer);", "this.u16    = new Uint16Array(this.buffer);", "this.s32    = new Int32Array(this.buffer);", "this.f32    = new Float32Array(this.buffer);", "this.f64    = new Float64Array(this.buffer);"})
    private void _createViews() {
        this.dataChar = this.data.asCharBuffer();
        this.dataShort = this.data.asShortBuffer();
        this.dataInt = this.data.asIntBuffer();
        this.dataLong = this.data.asLongBuffer();
        this.dataFloat = this.data.asFloatBuffer();
        this.dataDouble = this.data.asDoubleBuffer();
    }

    @JTranscMethodBody(target="cpp", value={"this->vptr = GET_OBJECT(JA_0, p0)->_data;"})
    private void _createViewsExtra(byte[] data) {
    }

    public static FastMemory alloc(int size) {
        return new FastMemory(size);
    }

    public static FastMemory wrap(byte[] bytes) {
        return new FastMemory(bytes);
    }

    public static FastMemory wrap(ByteBuffer buffer) {
        return new FastMemory(buffer.array());
    }

    @JTranscInline
    @HaxeMethodBody(value="return this._length;")
    @JTranscMethodBody(target="js", value={"return this._length;"})
    public final int getLength() {
        return this.length;
    }

    @JTranscInline
    @HaxeMethodBody(value="return this._data.length;")
    @JTranscMethodBody(target="js", value={"return this.buffer.byteLength;"})
    public final int getAllocatedLength() {
        return this.data.limit();
    }

    @JTranscInline
    @HaxeMethodBody(value="return this._data.get(p0);")
    @JTranscMethodBody(target="js", value={"return this.u8[p0];"})
    public final int getInt8(int index) {
        return this.data.get(index) & 0xFF;
    }

    @JTranscInline
    @HaxeMethodBody(value="return (this._data.getUInt16(p0) << 16) >> 16;")
    @JTranscMethodBody(target="js", value={"return this.view.getUint16(p0, true);"})
    public final int getInt16(int index) {
        return this.data.getShort(index) & 0xFFFF;
    }

    @JTranscInline
    @HaxeMethodBody(value="return this._data.getInt32(p0);")
    @JTranscMethodBody(target="js", value={"return this.view.getInt32(p0, true);"})
    public final int getInt32(int index) {
        return this.data.getInt(index);
    }

    @JTranscInline
    @HaxeMethodBody(value="return this._data.getInt64(p0);")
    @JTranscMethodBody(target="js", value={"return Int64.make(this.view.getInt32(p0, true), this.view.getInt32(p0 + 4, true));"})
    public final long getInt64(int index) {
        return this.data.getLong(index);
    }

    @JTranscInline
    @HaxeMethodBody(value="return this._data.getFloat(p0);")
    @JTranscMethodBody(target="js", value={"return this.view.getFloat32(p0, true);"})
    public final float getFloat32(int index) {
        return this.data.getFloat(index);
    }

    @JTranscInline
    @HaxeMethodBody(value="return this._data.getDouble(p0);")
    @JTranscMethodBody(target="js", value={"return this.view.getFloat64(p0, true);"})
    public final double getFloat64(int index) {
        return this.data.getDouble(index);
    }

    @JTranscInline
    @HaxeMethodBody(value="this._data.set(p0, p1);")
    @JTranscMethodBody(target="js", value={"this.u8[p0] = p1;"})
    public final void setInt8(int index, int value) {
        this.data.put(index, (byte)value);
    }

    @JTranscInline
    @HaxeMethodBody(value="this._data.setUInt16(p0, p1);")
    @JTranscMethodBody(target="js", value={"this.view.setInt16(p0, p1, true);"})
    public final void setInt16(int index, int value) {
        this.data.putShort(index, (short)value);
    }

    @JTranscInline
    @HaxeMethodBody(value="this._data.setInt32(p0, p1);")
    @JTranscMethodBody(target="js", value={"this.view.setInt32(p0, p1, true);"})
    public final void setInt32(int index, int value) {
        this.data.putInt(index, value);
    }

    @JTranscInline
    @HaxeMethodBody(value="this._data.setInt64(p0, p1);")
    @JTranscMethodBody(target="js", value={"this.view.setInt32(p0, p1.high); this.view.setInt32(p0 + 4, p1.low, true);"})
    public final void setInt64(int index, long value) {
        this.data.putLong(index, value);
    }

    @JTranscInline
    @HaxeMethodBody(value="this._data.setFloat(p0, p1);")
    @JTranscMethodBody(target="js", value={"this.view.setFloat32(p0, p1, true);"})
    public final void setFloat32(int index, float value) {
        this.data.putFloat(index, value);
    }

    @JTranscInline
    @HaxeMethodBody(value="this._data.setDouble(p0, p1);")
    @JTranscMethodBody(target="js", value={"this.view.setFloat64(p0, p1, true);"})
    public final void setFloat64(int index, double value) {
        this.data.putDouble(index, value);
    }

    @JTranscInline
    @HaxeMethodBody(value="return this._data.get(p0);")
    @JTranscMethodBody(target="js", value={"return this.u8[p0];"})
    public final int getAlignedInt8(int index) {
        return this.data.get(index) & 0xFF;
    }

    @JTranscInline
    @HaxeMethodBody(value="return (this.shortData.get(p0) << 16) >> 16;")
    @JTranscMethodBody(target="js", value={"return this.u16[p0];"})
    public final int getAlignedInt16(int index2) {
        return this.dataShort.get(index2) & 0xFFFF;
    }

    @JTranscInline
    @HaxeMethodBody(value="return this.intData.get(p0);")
    @JTranscMethodBodyList(value={@JTranscMethodBody(target="js", value={"return this.s32[p0];"}), @JTranscMethodBody(target="cpp", value={"return ((int *)this->vptr)[p0];"})})
    public final int getAlignedInt32(int index4) {
        return this.dataInt.get(index4);
    }

    @JTranscInline
    @HaxeMethodBody(value="return this._data.getInt64(p0 << 3);")
    @JTranscMethodBody(target="js", value={"return Int64.make(this.s32[p0 << 1 + 0], this.s32[p0 << 1 +1]);"})
    public final long getAlignedInt64(int index8) {
        return this.dataLong.get(index8);
    }

    @JTranscInline
    @HaxeMethodBody(value="return this.floatData.get(p0);")
    @JTranscMethodBody(target="js", value={"return this.f32[p0];"})
    public final float getAlignedFloat32(int index4) {
        return this.dataFloat.get(index4);
    }

    @JTranscInline
    @HaxeMethodBody(value="return this.doubleData.get(p0);")
    @JTranscMethodBody(target="js", value={"return this.f64[p0];"})
    public final double getAlignedFloat64(int index8) {
        return this.dataDouble.get(index8);
    }

    @JTranscInline
    @HaxeMethodBody(value="this._data.set(p0, p1);")
    @JTranscMethodBody(target="js", value={"this.u8[p0] = p1;"})
    public final void setAlignedInt8(int index, int value) {
        this.data.put(index, (byte)value);
    }

    @JTranscInline
    @HaxeMethodBody(value="this.shortData.set(p0, p1);")
    @JTranscMethodBody(target="js", value={"this.u16[p0] = p1;"})
    public final void setAlignedInt16(int index2, int value) {
        this.dataShort.put(index2, (short)value);
    }

    @JTranscInline
    @HaxeMethodBody(value="this.intData.set(p0, p1);")
    @JTranscMethodBody(target="js", value={"this.s32[p0] = p1;"})
    public final void setAlignedInt32(int index4, int value) {
        this.dataInt.put(index4, value);
    }

    @JTranscInline
    @HaxeMethodBody(value="this._data.setInt64(p0 << 3, p1);")
    @JTranscMethodBody(target="js", value={"this.s32[p0 << 1 + 0] = p1.low; this.s32[p0 << 1 + 1] = p1.high;"})
    public final void setAlignedInt64(int index8, long value) {
        this.dataLong.put(index8, value);
    }

    @JTranscInline
    @HaxeMethodBody(value="this.floatData.set(p0, p1);")
    @JTranscMethodBodyList(value={@JTranscMethodBody(target="js", value={"this.f32[p0] = p1;"}), @JTranscMethodBody(target="cpp", value={"((float *)this->vptr)[p0] = p1;"})})
    public final void setAlignedFloat32(int index4, float value) {
        this.dataFloat.put(index4, value);
    }

    @JTranscInline
    @HaxeMethodBody(value="this.doubleData.set(p0, p1);")
    @JTranscMethodBody(target="js", value={"this.f64[p0] = p1;"})
    public final void setAlignedFloat64(int index8, double value) {
        this.dataDouble.put(index8, value);
    }

    @JTranscInline
    @HaxeMethodBody(value="return this._data.get(p0);")
    @JTranscMethodBody(target="js", value={"return this.u8[p0];"})
    public final int getInt8_REV(int index) {
        return this.data.get(index) & 0xFF;
    }

    @JTranscInline
    @HaxeMethodBody(value="return N.swap16((this._data.getUInt16(p0) << 16) >> 16);")
    @JTranscMethodBody(target="js", value={"return this.view.getUint16(p0, false);"})
    public final int getInt16_REV(int index) {
        return Short.reverseBytes(this.data.getShort(index)) & 0xFFFF;
    }

    @JTranscInline
    @HaxeMethodBody(value="return N.swap32(this._data.getInt32(p0));")
    @JTranscMethodBody(target="js", value={"return this.view.getInt32(p0, false);"})
    public final int getInt32_REV(int index) {
        return Integer.reverseBytes(this.data.getInt(index));
    }

    @JTranscInline
    @HaxeMethodBody(value="return N.intBitsToFloat(N.swap32(this._data.getInt32(p0)));")
    @JTranscMethodBody(target="js", value={"return this.view.getFloat32(p0, false);"})
    public final float getFloat32_REV(int index) {
        return Float.intBitsToFloat(Integer.reverseBytes(this.data.getInt(index)));
    }

    public final void setArrayInt8(int index, ByteBuffer data, int offset, int len) {
        for (int n = 0; n < len; ++n) {
            this.setInt8(index + n, data.get(offset + n));
        }
    }

    @JTranscMethodBody(target="js", value={"var index = p0, data = p1.data.buffer, offset = p2, len = p3; new Int8Array(this.buffer, index, len).set(new Int8Array(data, offset, len));"})
    public final void setArrayInt8(int index, byte[] data, int offset, int len) {
        for (int n = 0; n < len; ++n) {
            this.setInt8(index + n, data[offset + n]);
        }
    }

    @JTranscMethodBody(target="js", value={"var index = p0, data = p1.data.buffer, offset = p2, len = p3; new Int8Array(this.buffer, index, len * 2).set(new Int8Array(data, offset * 2, len * 2));"})
    public final void setArrayInt16(int index, short[] data, int offset, int len) {
        for (int n = 0; n < len; ++n) {
            this.setInt16(index + n * 2, data[offset + n]);
        }
    }

    @JTranscMethodBody(target="js", value={"var index = p0, data = p1.data.buffer, offset = p2, len = p3; new Int8Array(this.buffer, index, len * 4).set(new Int8Array(data, offset * 4, len * 4));"})
    public final void setArrayInt32(int index, int[] data, int offset, int len) {
        for (int n = 0; n < len; ++n) {
            this.setInt32(index + n * 4, data[offset + n]);
        }
    }

    public final void setArrayInt64(int index, long[] data, int offset, int len) {
        for (int n = 0; n < len; ++n) {
            this.setInt64(index + n * 8, data[offset + n]);
        }
    }

    @JTranscMethodBody(target="js", value={"var index = p0, data = p1.data.buffer, offset = p2, len = p3; new Int8Array(this.buffer, index, len * 4).set(new Int8Array(data, offset * 4, len * 4));"})
    public final void setArrayFloat32(int index, float[] data, int offset, int len) {
        for (int n = 0; n < len; ++n) {
            this.setFloat32(index + n * 4, data[offset + n]);
        }
    }

    @JTranscMethodBody(target="js", value={"var index = p0, data = p1.data.buffer, offset = p2, len = p3; new Int8Array(this.buffer, index, len * 8).set(new Int8Array(data, offset * 8, len * 8));"})
    public final void setArrayFloat64(int index, float[] data, int offset, int len) {
        for (int n = 0; n < len; ++n) {
            this.setFloat32(index + n * 4, data[offset + n]);
        }
    }

    @HaxeMethodBody(value="p2.getBytes().blit(p3, p0.getBytes(), p1, p4);")
    public static void copy(byte[] from, int fromOffset, byte[] to, int toOffset, int length) {
        for (int n = 0; n < length; ++n) {
            to[toOffset + n] = from[fromOffset + n];
        }
    }

    @HaxeMethodBody(value="p2.getBytes().blit(p3, p0.getBytes(), p1, p4);")
    public static void copy(FastMemory from, int fromOffset, byte[] to, int toOffset, int length) {
        for (int n = 0; n < length; ++n) {
            to[toOffset + n] = (byte)from.getInt8(fromOffset + n);
        }
    }

    @HaxeMethodBody(value="p2.getBytes().blit(p3, p0.getBytes(), p1, p4);")
    public static void copy(byte[] from, int fromOffset, FastMemory to, int toOffset, int length) {
        for (int n = 0; n < length; ++n) {
            to.setInt8(toOffset + n, from[fromOffset + n]);
        }
    }

    @HaxeMethodBody(value="p2.getBytes().blit(p3, p0.getBytes(), p1, p4);")
    public static void copy(FastMemory from, int fromOffset, FastMemory to, int toOffset, int length) {
        for (int n = 0; n < length; ++n) {
            to.setInt8(toOffset + n, from.getInt8(fromOffset + n));
        }
    }
}

