/*
 * Decompiled with CFR 0.152.
 */
package com.jtransc.charset;

import com.jtransc.charset.JTranscCharBuffer;
import com.jtransc.charset.JTranscCharset;
import java.io.ByteArrayOutputStream;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.util.HashMap;
import java.util.Map;

public class JTranscCharsetSingleByte
extends JTranscCharset {
    final String decode;
    final Map<Character, Byte> encode;
    final byte invalidChar = (byte)63;

    public JTranscCharsetSingleByte(String[] aliases, String chars) {
        super(aliases, 1, 1.0f, 1);
        this.decode = chars;
        this.encode = new HashMap<Character, Byte>(chars.length());
        for (int n = 0; n < chars.length(); ++n) {
            this.encode.put(Character.valueOf(chars.charAt(n)), (byte)n);
        }
    }

    @Override
    public final void encode(char[] in, int offset, int len, ByteArrayOutputStream out) {
        for (int n = 0; n < len; ++n) {
            char c = in[offset + n];
            Byte b = this.encode.get(Character.valueOf(c));
            if (b != null) {
                out.write(b.byteValue());
                continue;
            }
            out.write(63);
        }
    }

    @Override
    public final void decode(byte[] in, int offset, int len, JTranscCharBuffer out) {
        for (int n = 0; n < len; ++n) {
            int b = in[offset + n] & 0xFF;
            out.append(this.decode.charAt(b));
        }
    }

    @Override
    public final void decode(ByteBuffer in, CharBuffer out) {
        while (in.hasRemaining() && out.hasRemaining()) {
            int b = in.get() & 0xFF;
            out.append(this.decode.charAt(b));
        }
    }
}

