/*
 * Decompiled with CFR 0.152.
 */
package com.jtransc.crypto;

import com.jtransc.JTranscSystem;
import com.jtransc.annotation.JTranscAddHeader;
import com.jtransc.annotation.JTranscMethodBody;
import com.jtransc.annotation.JTranscMethodBodyList;
import com.jtransc.annotation.haxe.HaxeMethodBody;
import com.jtransc.annotation.haxe.HaxeMethodBodyList;
import com.jtransc.annotation.haxe.HaxeMethodBodyPost;
import com.jtransc.annotation.haxe.HaxeMethodBodyPre;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;

@JTranscAddHeader(target="as3", value={"import flash.crypto.generateRandomBytes;"})
public class JTranscCrypto {
    public static SecureRandomProvider secureRandomProvider = new SecureRandomProvider(){};

    public static void fillSecureRandomBytes(byte[] data) {
        if (secureRandomProvider == null || data == null) {
            throw new RuntimeException("fillSecureRandomBytes");
        }
        secureRandomProvider.fillSecureRandomBytes(data);
    }

    public static byte[] md5(byte[] data) {
        try {
            MessageDigest md5 = MessageDigest.getInstance("MD5");
            return md5.digest(data);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("");
        }
    }

    public static byte[] sha1(byte[] data) {
        try {
            MessageDigest sha1 = MessageDigest.getInstance("SHA1");
            return sha1.digest(data);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("");
        }
    }

    public static class SecureRandomProvider {
        @HaxeMethodBodyPre(value="var bytes = p0;\nvar length = bytes.length;\n\n")
        @HaxeMethodBodyList(value={@HaxeMethodBody(target="js", value="try {\n  var _bytes = bytes.data;\n  untyped __js__(\"crypto.getRandomValues(_bytes);\");\n  return;\n} catch (e:Dynamic) {\n\n}\n"), @HaxeMethodBody(value="")})
        @HaxeMethodBodyPost(value="for (n in 0 ... length) {\n  bytes.set(n, Std.int(Math.random() * 255));\n}")
        @JTranscMethodBodyList(value={@JTranscMethodBody(target="js", value={"N.fillSecureRandomBytes(p0);"}), @JTranscMethodBody(target="cs", value={"var len = p0.length; var temp = new byte[len]; var provider = (new System.Security.Cryptography.RNGCryptoServiceProvider()); provider.GetBytes(temp); for (int n = 0; n < len; n++) p0[n] = (sbyte)temp[n];"}), @JTranscMethodBody(target="as3", value={"N.fillSecureRandomBytes(p0.data);"}), @JTranscMethodBody(target="dart", value={"N.fillSecureRandomBytes(p0.data);"}), @JTranscMethodBody(target="php", value={"N::fillSecureRandomBytes($p0->data);"})})
        public void fillSecureRandomBytes(byte[] data) {
            if (!JTranscSystem.isJTransc()) {
                SecureRandom secureRandom = new SecureRandom();
                secureRandom.nextBytes(data);
            } else {
                System.err.println("[IMPORTANT WARNING] Using SecureRandom without properly setting JTranscCrypto.secureRandomProvider");
            }
        }
    }
}

