/*
 * Decompiled with CFR 0.152.
 */
package com.jtransc.crypto.org.bouncycastle;

import com.jtransc.crypto.org.bouncycastle.GeneralDigest;
import java.security.DigestException;
import java.security.MessageDigest;

public class GeneralDigestAdaptor
extends MessageDigest {
    private final GeneralDigest generalDigest;

    public GeneralDigestAdaptor(GeneralDigest generalDigest) {
        super(generalDigest.getAlgorithmName());
        this.generalDigest = generalDigest;
    }

    @Override
    protected int engineGetDigestLength() {
        return this.generalDigest.getDigestSize();
    }

    @Override
    protected void engineUpdate(byte input) {
        this.generalDigest.update(input);
    }

    @Override
    protected void engineUpdate(byte[] input, int offset, int len) {
        this.generalDigest.update(input, offset, len);
    }

    @Override
    protected byte[] engineDigest() {
        byte[] out = new byte[this.engineGetDigestLength()];
        try {
            this.engineDigest(out, 0, out.length);
        }
        catch (DigestException e) {
            e.printStackTrace();
            return new byte[0];
        }
        return out;
    }

    @Override
    protected int engineDigest(byte[] buf, int offset, int len) throws DigestException {
        this.generalDigest.doFinal(buf, offset);
        return this.engineGetDigestLength();
    }

    @Override
    protected void engineReset() {
        this.generalDigest.reset();
    }

    @Override
    public native Object clone() throws CloneNotSupportedException;
}

