/*
 * Decompiled with CFR 0.152.
 */
package com.jtransc.io;

import com.jtransc.annotation.JTranscMethodBody;
import com.jtransc.io.JTranscConsole;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;

public class JTranscConsolePrintStream
extends PrintStream {
    final boolean error;
    final ConsoleBaseStream stream;

    public JTranscConsolePrintStream(boolean error) {
        this(error ? new ConsoleErrorStream() : new ConsoleOutputStream(), error);
    }

    private JTranscConsolePrintStream(ConsoleBaseStream stream, boolean error) {
        super(stream);
        this.stream = stream;
        this.error = error;
    }

    @Override
    public void println(String x) {
        JTranscConsole.logOrError(this.stream.sb.toString() + x, this.error);
        this.stream.sb.setLength(0);
    }

    private static class ConsoleErrorStream
    extends ConsoleBaseStream {
        public ConsoleErrorStream() {
            super(true);
        }

        @Override
        @JTranscMethodBody(target="dart", value={"stderr.writeCharCode(p0);"})
        public void write(int b) throws IOException {
            this._write(b);
        }
    }

    private static class ConsoleOutputStream
    extends ConsoleBaseStream {
        public ConsoleOutputStream() {
            super(false);
        }

        @Override
        @JTranscMethodBody(target="dart", value={"stdout.writeCharCode(p0);"})
        public void write(int b) throws IOException {
            this._write(b);
        }
    }

    private static abstract class ConsoleBaseStream
    extends OutputStream {
        public StringBuilder sb = new StringBuilder();
        private final boolean error;

        public ConsoleBaseStream(boolean error) {
            this.error = error;
        }

        protected void _write(int b) throws IOException {
            char c = (char)b;
            if (c == '\n') {
                JTranscConsole.logOrError(this.sb.toString(), this.error);
                this.sb.setLength(0);
            } else {
                this.sb.append(c);
            }
        }
    }
}

