/*
 * Decompiled with CFR 0.152.
 */
package com.jtransc.io.ra;

import com.jtransc.JTranscBits;
import com.jtransc.io.ra.RASlice;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.Arrays;

public abstract class RAStream {
    private long position = 0L;
    private byte[] scratch = new byte[8];

    public final void setPosition(long position) {
        this.position = position;
    }

    public final long getPosition() {
        return this.position;
    }

    public final long getAvailable() {
        return this.getLength() - this.getPosition();
    }

    public final void skip(long count) {
        this.position += Math.min(this.getAvailable(), count);
    }

    public final int read(byte[] ref, int pos, int len) {
        int readed = this.read(this.position, ref, pos, len);
        if (readed > 0) {
            this.position += (long)readed;
        }
        return readed;
    }

    public final void write(byte[] ref, int pos, int len) {
        this.write(this.position, ref, pos, len);
        this.position += (long)len;
    }

    public int readU8() {
        return this.readS8() & 0xFF;
    }

    public int readU8_LE() {
        return this.readU8();
    }

    public int readU8_BE() {
        return this.readS8_BE() & 0xFF;
    }

    public int readU16_LE() {
        return this.readS16_LE() & 0xFFFF;
    }

    public int readU16_BE() {
        return this.readS16_BE() & 0xFFFF;
    }

    public long readU32_LE() {
        return (long)this.readS32_LE() & 0xFFFFFFFFL;
    }

    public long readU32_BE() {
        return (long)this.readS32_BE() & 0xFFFFFFFFL;
    }

    public byte readS8_LE() {
        return this.readS8();
    }

    public short readS16_LE() {
        this.read(this.scratch, 0, 2);
        return JTranscBits.readInt16LE(this.scratch, 0);
    }

    public int readS32_LE() {
        this.read(this.scratch, 0, 4);
        return JTranscBits.readInt32LE(this.scratch, 0);
    }

    public long readS64_LE() {
        this.read(this.scratch, 0, 8);
        return JTranscBits.readInt64LE(this.scratch, 0);
    }

    public byte readS8() {
        this.read(this.scratch, 0, 1);
        return this.scratch[0];
    }

    public byte readS8_BE() {
        return this.readS8();
    }

    public short readS16_BE() {
        this.read(this.scratch, 0, 2);
        return JTranscBits.readInt16BE(this.scratch, 0);
    }

    public int readS32_BE() {
        this.read(this.scratch, 0, 4);
        return JTranscBits.readInt32BE(this.scratch, 0);
    }

    public long readS64_BE() {
        this.read(this.scratch, 0, 8);
        return JTranscBits.readInt64BE(this.scratch, 0);
    }

    public byte[] readBytes(int count) {
        byte[] out = new byte[count];
        int readed = this.read(out, 0, out.length);
        return Arrays.copyOf(out, readed);
    }

    public byte[] readBytesExact(int count) {
        int pos;
        int readed;
        byte[] out = new byte[count];
        for (pos = 0; pos < count && (readed = this.read(out, pos, out.length - pos)) > 0; pos += readed) {
        }
        if (pos < count) {
            throw new RuntimeException("Can't read bytes " + count + " just able to read " + pos);
        }
        return out;
    }

    public byte[] readBytes(long count) {
        return this.readBytes((int)count);
    }

    public String readStringz(int count, Charset charset) {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        while (count > 0) {
            byte c = this.readS8_LE();
            --count;
            if (c <= 0) break;
            out.write(c);
        }
        this.skip(count);
        return new String(out.toByteArray(), charset);
    }

    public RASlice readSlice(long count) {
        long actualCount = Math.min(count, this.getAvailable());
        RASlice out = new RASlice(this, this.getPosition(), this.getPosition() + actualCount);
        this.setPosition(this.getPosition() + actualCount);
        return out;
    }

    public RASlice slice() {
        return new RASlice(this, 0L, this.length());
    }

    public RASlice slice(long start, long end) {
        return new RASlice(this, start, end);
    }

    public RASlice sliceWithSize(long start, long size) {
        return new RASlice(this, start, start + size);
    }

    public RASlice sliceAvailable(long start) {
        return new RASlice(this, start, this.getLength());
    }

    public byte[] readAvailableBytes() {
        return this.readBytesExact((int)this.getAvailable());
    }

    public abstract void setLength(long var1);

    public abstract long getLength();

    protected abstract int read(long var1, byte[] var3, int var4, int var5);

    protected abstract void write(long var1, byte[] var3, int var4, int var5);

    public void close() {
    }

    public final InputStream createInputStream() {
        return new InputStream(){
            byte[] scratch = new byte[1];

            @Override
            public int read() throws IOException {
                int count = this.read(this.scratch, 0, 1);
                return count <= 0 ? -1 : this.scratch[0];
            }

            @Override
            public int read(byte[] b, int off, int len) throws IOException {
                return RAStream.this.read(b, off, len);
            }
        };
    }

    public byte[] getAllBytes() {
        int length = (int)this.getLength();
        byte[] out = new byte[length];
        this.read(0L, out, 0, length);
        return out;
    }

    public final OutputStream createOutputStream() {
        throw new RuntimeException("RAStream.createOutputStream not implemented!!");
    }

    public final DataInputStream createDataInput() {
        return new DataInputStream(this.createInputStream());
    }

    public final DataOutputStream createDataOutput() {
        return new DataOutputStream(this.createOutputStream());
    }

    public final long length() {
        return this.getLength();
    }

    public boolean eof() {
        return this.getAvailable() <= 0L;
    }
}

