/*
 * Decompiled with CFR 0.152.
 */
package com.jtransc.time;

import com.jtransc.JTranscSystem;
import com.jtransc.annotation.JTranscMethodBody;
import com.jtransc.annotation.JTranscMethodBodyList;
import com.jtransc.annotation.haxe.HaxeMethodBody;

public class JTranscClock {
    public static Impl impl = new Impl(null){};

    public static class Impl {
        public Impl parent;

        public Impl(Impl parent) {
            this.parent = parent;
        }

        @HaxeMethodBody(value="return N.getTime();")
        @JTranscMethodBodyList(value={@JTranscMethodBody(target="php", value={"return N::getTime();"}), @JTranscMethodBody(target="js", value={"return N.getTime();"}), @JTranscMethodBody(target="cpp", value={"return N::getTime();"}), @JTranscMethodBody(target="cs", value={"return N.getTime();"}), @JTranscMethodBody(target="as3", value={"return new Date().time;"}), @JTranscMethodBody(target="dart", value={"return new DateTime.now().millisecondsSinceEpoch.toDouble();"})})
        public double fastTime() {
            if (this.parent != null) {
                return this.parent.fastTime();
            }
            if (JTranscSystem.isJTransc()) {
                throw new RuntimeException("Not implemented JTranscSystem.fastTime()");
            }
            return (double)System.nanoTime() / 1000000.0;
        }

        @JTranscMethodBodyList(value={@JTranscMethodBody(target="js", value={"return N.hrtime();"}), @JTranscMethodBody(target="cpp", value={"return N::nanoTime();"}), @JTranscMethodBody(target="php", value={"return N::nanoTime();"})})
        public long nanoTime() {
            if (JTranscSystem.isJTransc()) {
                return System.currentTimeMillis() * 1000000L;
            }
            return System.nanoTime();
        }

        @HaxeMethodBody(target="sys", value="Sys.sleep(p0 / 1000.0);")
        @JTranscMethodBodyList(value={@JTranscMethodBody(target="cs", value={"System.Threading.Thread.Sleep((int)p0);"}), @JTranscMethodBody(target="dart", value={"sleep(new Duration(milliseconds: p0.toInt()));"}), @JTranscMethodBody(target="php", value={"usleep($p0 * 1000);"})})
        public void sleep(double ms) {
            if (this.parent != null) {
                this.parent.sleep(ms);
                return;
            }
            if (JTranscSystem.isJTransc()) {
                double current;
                double start = JTranscSystem.fastTime();
                while (!((current = JTranscSystem.fastTime()) - start >= ms)) {
                }
            } else {
                Impl._sleep(ms);
            }
        }

        private static void _sleep(double ms) {
            try {
                Thread.sleep((long)ms);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }
}

