/*
 * Decompiled with CFR 0.152.
 */
package j;

import com.jtransc.ds.FastIntMap;
import com.jtransc.ds.FastStringMap;
import j.ClassInfo;
import j.MemberInfo;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;

public class ProgramReflection {
    public static ClassInfo[] _classInfos;
    public static String[] _classNames;
    public static FastStringMap<ClassInfo> _classInfosByName;
    public static FastIntMap<FastIntMap<MemberInfo>> _constructorsInfo;
    public static FastIntMap<FastIntMap<MemberInfo>> _methodInfos;
    public static FastIntMap<FastIntMap<MemberInfo>> _fieldsInfos;

    public static void _ensure() {
        if (_classInfos != null) {
            return;
        }
        _classInfosByName = new FastStringMap();
        _classInfos = ProgramReflection.getAllClasses();
        if (_classInfos != null) {
            _classNames = new String[_classInfos.length];
            for (ClassInfo info : _classInfos) {
                if (info == null) continue;
                _classInfosByName.set(info.name, info);
                ProgramReflection._classNames[info.id] = info.name;
            }
        }
    }

    public static void _ensureConstructors() {
        if (_constructorsInfo != null) {
            return;
        }
        ProgramReflection._ensure();
        _constructorsInfo = new FastIntMap();
        for (ClassInfo info : _classInfos) {
            if (info == null) continue;
            FastIntMap<MemberInfo> map = new FastIntMap<MemberInfo>();
            _constructorsInfo.set(info.id, map);
            MemberInfo[] minfo = ProgramReflection.getConstructors(info.id);
            if (minfo == null) continue;
            for (MemberInfo i : minfo) {
                map.set(i.id, i);
            }
        }
    }

    public static void _ensureFields() {
        if (_fieldsInfos != null) {
            return;
        }
        ProgramReflection._ensure();
        _fieldsInfos = new FastIntMap();
        for (ClassInfo info : _classInfos) {
            if (info == null) continue;
            FastIntMap<MemberInfo> map = new FastIntMap<MemberInfo>();
            _fieldsInfos.set(info.id, map);
            MemberInfo[] minfo = ProgramReflection.getFields(info.id);
            if (minfo == null) continue;
            for (MemberInfo i : minfo) {
                map.set(i.id, i);
            }
        }
    }

    public static void _ensureMethods() {
        if (_methodInfos != null) {
            return;
        }
        ProgramReflection._ensure();
        _methodInfos = new FastIntMap();
        for (ClassInfo info : _classInfos) {
            if (info == null) continue;
            FastIntMap<MemberInfo> map = new FastIntMap<MemberInfo>();
            _methodInfos.set(info.id, map);
            MemberInfo[] minfo = ProgramReflection.getMethods(info.id);
            if (minfo == null) continue;
            for (MemberInfo i : minfo) {
                map.set(i.id, i);
            }
        }
    }

    public static boolean hasClassWithName(String name) {
        ProgramReflection._ensure();
        return _classInfosByName.has(name);
    }

    public static ClassInfo getClassInfoWithName(String name) {
        ProgramReflection._ensure();
        return ProgramReflection.hasClassWithName(name) ? _classInfosByName.get(name) : null;
    }

    public static ClassInfo[] getAllClasses() {
        return _classInfos != null ? _classInfos : AllClasses.getAllClasses();
    }

    public static MemberInfo[] getConstructors(int classId) {
        return AllConstructors.getConstructors(classId);
    }

    public static MemberInfo[] getMethods(int classId) {
        return AllMethods.getMethods(classId);
    }

    public static MemberInfo[] getFields(int classId) {
        return AllFields.getFields(classId);
    }

    public static Object dynamicNew(int classId, int constructorId, Object[] params) {
        return DynamicNew.dynamicNew(classId, constructorId, params);
    }

    public static Object dynamicInvoke(int classId, int methodId, Object object, Object[] params) {
        return DynamicInvoke.dynamicInvoke(classId, methodId, object, params);
    }

    public static Object dynamicGet(int classId, int fieldId, Object object) {
        return DynamicGet.dynamicGet(classId, fieldId, object);
    }

    public static void dynamicSet(int classId, int fieldId, Object object, Object value) {
        DynamicSet.dynamicSet(classId, fieldId, object, value);
    }

    public static Annotation[] getClassAnnotations(int classId) {
        return new Annotation[0];
    }

    public static Annotation[] getFieldAnnotations(int classId, int fieldId) {
        return new Annotation[0];
    }

    public static Annotation[] getMethodAnnotations(int classId, int methodId) {
        return new Annotation[0];
    }

    public static Annotation[] getMethodArgumentAnnotations(int classId, int methodId, int argIndex) {
        return new Annotation[0];
    }

    public static MemberInfo getMethodInfo(int classId, int methodId) {
        ProgramReflection._ensureMethods();
        return _methodInfos.get(classId).get(methodId);
    }

    public static native Method getMethodByInfo(Class<?> var0, MemberInfo var1);

    public static Class<?> getClassById(int classId) {
        ProgramReflection._ensure();
        try {
            return Class.forName(_classNames[classId]);
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Method getDirectMethod(int classId, int methodId) {
        return ProgramReflection.getMethodByInfo(ProgramReflection.getClassById(classId), ProgramReflection.getMethodInfo(classId, methodId));
    }

    public static class DynamicSet {
        public static void dynamicSet(int classId, int fieldId, Object object, Object value) {
        }
    }

    public static class DynamicGet {
        public static Object dynamicGet(int classId, int fieldId, Object object) {
            return null;
        }
    }

    public static class DynamicInvokeLast {
        public static Object dynamicInvoke(int classId, int methodId, Object object, Object[] params) {
            return null;
        }
    }

    public static class DynamicInvokeMiddle {
        public static Object dynamicInvoke(int classId, int methodId, Object object, Object[] params) {
            return null;
        }
    }

    public static class DynamicInvokeFirst {
        public static Object dynamicInvoke(int classId, int methodId, Object object, Object[] params) {
            return null;
        }
    }

    public static class DynamicInvoke {
        public static Object dynamicInvoke(int classId, int methodId, Object object, Object[] params) {
            Object ret = DynamicInvokeFirst.dynamicInvoke(classId, methodId, object, params);
            if (ret != null) {
                return ret;
            }
            ret = DynamicInvokeMiddle.dynamicInvoke(classId, methodId, object, params);
            if (ret != null) {
                return ret;
            }
            return DynamicInvokeLast.dynamicInvoke(classId, methodId, object, params);
        }
    }

    public static class DynamicNew {
        public static Object dynamicNew(int classId, int constructorId, Object[] params) {
            return null;
        }
    }

    public static class AllFieldsLast {
        public static MemberInfo[] getFields(int classId) {
            return new MemberInfo[0];
        }
    }

    public static class AllFieldsMiddle {
        public static MemberInfo[] getFields(int classId) {
            return new MemberInfo[0];
        }
    }

    public static class AllFieldsFirst {
        public static MemberInfo[] getFields(int classId) {
            return new MemberInfo[0];
        }
    }

    public static class AllFields {
        public static MemberInfo[] getFields(int classId) {
            MemberInfo[] ret = AllFieldsFirst.getFields(classId);
            if (ret != null && ret.length > 0) {
                return ret;
            }
            ret = AllFieldsMiddle.getFields(classId);
            if (ret != null && ret.length > 0) {
                return ret;
            }
            return AllFieldsLast.getFields(classId);
        }
    }

    public static class AllMethodsLast {
        public static MemberInfo[] getMethods(int classId) {
            return new MemberInfo[0];
        }
    }

    public static class AllMethodsMiddle {
        public static MemberInfo[] getMethods(int classId) {
            return new MemberInfo[0];
        }
    }

    public static class AllMethodsFirst {
        public static MemberInfo[] getMethods(int classId) {
            return new MemberInfo[0];
        }
    }

    public static class AllMethods {
        public static MemberInfo[] getMethods(int classId) {
            MemberInfo[] ret = AllMethodsFirst.getMethods(classId);
            if (ret != null && ret.length > 0) {
                return ret;
            }
            ret = AllMethodsMiddle.getMethods(classId);
            if (ret != null && ret.length > 0) {
                return ret;
            }
            return AllMethodsLast.getMethods(classId);
        }
    }

    public static class AllConstructorsLast {
        public static MemberInfo[] getConstructors(int classId) {
            return new MemberInfo[0];
        }
    }

    public static class AllConstructorsMiddle {
        public static MemberInfo[] getConstructors(int classId) {
            return new MemberInfo[0];
        }
    }

    public static class AllConstructorsFirst {
        public static MemberInfo[] getConstructors(int classId) {
            return new MemberInfo[0];
        }
    }

    public static class AllConstructors {
        public static MemberInfo[] getConstructors(int classId) {
            MemberInfo[] ret = AllConstructorsFirst.getConstructors(classId);
            if (ret != null && ret.length > 0) {
                return ret;
            }
            ret = AllConstructorsMiddle.getConstructors(classId);
            if (ret != null && ret.length > 0) {
                return ret;
            }
            return AllConstructorsLast.getConstructors(classId);
        }
    }

    public static class AllClasses {
        public ClassInfo[] test;

        public static ClassInfo[] getAllClasses() {
            ClassInfo[][] classInfoParts = new ClassInfo[][]{AllClasses.getAllClasses3000(), AllClasses.getAllClasses6000(), AllClasses.getAllClasses9000(), AllClasses.getAllClasses12000(), AllClasses.getAllClasses15000(), AllClasses.getAllClassesMax()};
            ClassInfo[] classInfo = new ClassInfo[AllClasses.getAllClassesCount()];
            ClassInfo[][] classInfoArrayArray = classInfoParts;
            int n = classInfoArrayArray.length;
            for (int i = 0; i < n; ++i) {
                ClassInfo[] classInfoPart;
                ClassInfo[] classInfoArray = classInfoPart = classInfoArrayArray[i];
                int n2 = classInfoArray.length;
                for (int j = 0; j < n2; ++j) {
                    ClassInfo aClassInfo;
                    classInfo[aClassInfo.id] = aClassInfo = classInfoArray[j];
                }
            }
            return classInfo;
        }

        public static int getAllClassesCount() {
            return 0;
        }

        public static ClassInfo[] getAllClasses3000() {
            return new ClassInfo[0];
        }

        public static ClassInfo[] getAllClasses6000() {
            return new ClassInfo[0];
        }

        public static ClassInfo[] getAllClasses9000() {
            return new ClassInfo[0];
        }

        public static ClassInfo[] getAllClasses12000() {
            return new ClassInfo[0];
        }

        public static ClassInfo[] getAllClasses15000() {
            return new ClassInfo[0];
        }

        public static ClassInfo[] getAllClassesMax() {
            return new ClassInfo[0];
        }
    }
}

