/*
 * Decompiled with CFR 0.152.
 */
package com.jtransc;

import com.jtransc.annotation.JTranscAsync;
import com.jtransc.annotation.JTranscInline;
import com.jtransc.annotation.JTranscInvisible;
import com.jtransc.annotation.JTranscMethodBody;
import com.jtransc.annotation.JTranscSync;
import com.jtransc.annotation.haxe.HaxeMethodBody;
import com.jtransc.annotation.haxe.HaxeMethodBodyList;
import java.nio.ByteBuffer;

@JTranscInvisible
public class JTranscBits {
    @JTranscSync
    public static int unsignedMod(int value, int mod) {
        return (value % mod + mod) % mod;
    }

    @JTranscSync
    public static short swap(short x) {
        return Short.reverseBytes(x);
    }

    @JTranscSync
    public static char swap(char x) {
        return Character.reverseBytes(x);
    }

    @JTranscSync
    public static int swap(int x) {
        return Integer.reverseBytes(x);
    }

    @JTranscSync
    public static long swap(long x) {
        return Long.reverseBytes(x);
    }

    @JTranscSync
    public static char makeChar(byte b1, byte b0) {
        return (char)(b1 << 8 | b0 & 0xFF);
    }

    @JTranscSync
    public static long makeLong(byte b7, byte b6, byte b5, byte b4, byte b3, byte b2, byte b1, byte b0) {
        return (long)b7 << 56 | ((long)b6 & 0xFFL) << 48 | ((long)b5 & 0xFFL) << 40 | ((long)b4 & 0xFFL) << 32 | ((long)b3 & 0xFFL) << 24 | ((long)b2 & 0xFFL) << 16 | ((long)b1 & 0xFFL) << 8 | (long)b0 & 0xFFL;
    }

    @JTranscSync
    public static long makeLong(byte[] bytes) {
        return JTranscBits.makeLong(bytes[0], bytes[1], bytes[2], bytes[3], bytes[4], bytes[5], bytes[6], bytes[7]);
    }

    @JTranscSync
    public static final int makeInt(byte b3, byte b2, byte b1, byte b0) {
        return (b3 & 0xFF) << 24 | (b2 & 0xFF) << 16 | (b1 & 0xFF) << 8 | (b0 & 0xFF) << 0;
    }

    @JTranscSync
    public static final int makeInt(int b3, int b2, int b1, int b0) {
        return (b3 & 0xFF) << 24 | (b2 & 0xFF) << 16 | (b1 & 0xFF) << 8 | (b0 & 0xFF) << 0;
    }

    @JTranscSync
    public static int makeInt(byte[] bytes) {
        return JTranscBits.makeInt(bytes[0], bytes[1], bytes[2], bytes[3]);
    }

    @JTranscSync
    public static int makeInt(byte[] bytes, int offset) {
        return JTranscBits.makeInt(bytes[offset + 0], bytes[offset + 1], bytes[offset + 2], bytes[offset + 3]);
    }

    @JTranscSync
    public static byte long7(long x) {
        return (byte)(x >> 56);
    }

    @JTranscSync
    public static byte long6(long x) {
        return (byte)(x >> 48);
    }

    @JTranscSync
    public static byte long5(long x) {
        return (byte)(x >> 40);
    }

    @JTranscSync
    public static byte long4(long x) {
        return (byte)(x >> 32);
    }

    @JTranscSync
    public static byte long3(long x) {
        return (byte)(x >> 24);
    }

    @JTranscSync
    public static byte long2(long x) {
        return (byte)(x >> 16);
    }

    @JTranscSync
    public static byte long1(long x) {
        return (byte)(x >> 8);
    }

    @JTranscSync
    public static byte long0(long x) {
        return (byte)(x >> 0);
    }

    @JTranscInline
    @JTranscSync
    public static byte int3(int x) {
        return (byte)(x >> 24);
    }

    @JTranscInline
    @JTranscSync
    public static byte int2(int x) {
        return (byte)(x >> 16);
    }

    @JTranscInline
    @JTranscSync
    public static byte int1(int x) {
        return (byte)(x >> 8);
    }

    @JTranscInline
    @JTranscSync
    public static byte int0(int x) {
        return (byte)(x >> 0);
    }

    @JTranscSync
    public static short makeShort(byte b1, byte b0) {
        return (short)((b1 & 0xFF) << 8 | (b0 & 0xFF) << 0);
    }

    @JTranscSync
    public static short makeShort(byte[] bytes) {
        return JTranscBits.makeShort(bytes[0], bytes[1]);
    }

    @JTranscSync
    public static void writeCharBE(byte[] out, int offset, char value) {
        out[offset + 0] = (byte)(value >>> 8 & 0xFF);
        out[offset + 1] = (byte)(value >>> 0 & 0xFF);
    }

    @JTranscSync
    public static void writeShortBE(byte[] out, int offset, short value) {
        out[offset + 0] = (byte)(value >>> 8 & 0xFF);
        out[offset + 1] = (byte)(value >>> 0 & 0xFF);
    }

    @JTranscSync
    public static void writeIntBE(byte[] out, int offset, int value) {
        out[offset + 0] = (byte)(value >>> 24 & 0xFF);
        out[offset + 1] = (byte)(value >>> 16 & 0xFF);
        out[offset + 2] = (byte)(value >>> 8 & 0xFF);
        out[offset + 3] = (byte)(value >>> 0 & 0xFF);
    }

    @JTranscSync
    public static void writeLongBE(byte[] out, int offset, long value) {
        int h = (int)(value >> 32);
        int l = (int)(value >> 0);
        out[offset + 0] = (byte)(h >>> 24);
        out[offset + 1] = (byte)(h >>> 16);
        out[offset + 2] = (byte)(h >>> 8);
        out[offset + 3] = (byte)(h >>> 0);
        out[offset + 4] = (byte)(l >>> 24);
        out[offset + 5] = (byte)(l >>> 16);
        out[offset + 6] = (byte)(l >>> 8);
        out[offset + 7] = (byte)(l >>> 0);
    }

    @JTranscSync
    public static void writeFloatBE(byte[] out, int offset, float value) {
        JTranscBits.writeIntBE(out, offset, Float.floatToRawIntBits(value));
    }

    @JTranscSync
    public static void writeDoubleBE(byte[] out, int offset, double value) {
        JTranscBits.writeLongBE(out, offset, Double.doubleToRawLongBits(value));
    }

    @JTranscSync
    public static void writeCharLE(byte[] out, int offset, char value) {
        out[offset + 1] = (byte)(value >>> 8 & 0xFF);
        out[offset + 0] = (byte)(value >>> 0 & 0xFF);
    }

    @JTranscSync
    public static void writeShortLE(byte[] out, int offset, short value) {
        out[offset + 1] = (byte)(value >>> 8 & 0xFF);
        out[offset + 0] = (byte)(value >>> 0 & 0xFF);
    }

    @JTranscSync
    public static void writeIntLE(byte[] out, int offset, int value) {
        out[offset + 3] = (byte)(value >>> 24 & 0xFF);
        out[offset + 2] = (byte)(value >>> 16 & 0xFF);
        out[offset + 1] = (byte)(value >>> 8 & 0xFF);
        out[offset + 0] = (byte)(value >>> 0 & 0xFF);
    }

    @JTranscSync
    public static void writeFloatLE(byte[] out, int offset, float value) {
        JTranscBits.writeIntLE(out, offset, Float.floatToRawIntBits(value));
    }

    @JTranscSync
    public static void writeLongLE(byte[] out, int offset, long value) {
        int h = (int)(value >> 32);
        int l = (int)(value >> 0);
        out[offset + 7] = (byte)(h >>> 24);
        out[offset + 6] = (byte)(h >>> 16);
        out[offset + 5] = (byte)(h >>> 8);
        out[offset + 4] = (byte)(h >>> 0);
        out[offset + 3] = (byte)(l >>> 24);
        out[offset + 2] = (byte)(l >>> 16);
        out[offset + 1] = (byte)(l >>> 8);
        out[offset + 0] = (byte)(l >>> 0);
    }

    @JTranscSync
    public static void writeDoubleLE(byte[] out, int offset, double value) {
        JTranscBits.writeLongLE(out, offset, Double.doubleToRawLongBits(value));
    }

    @JTranscSync
    public static void writeShortBE(byte[] out, short value) {
        JTranscBits.writeShortBE(out, 0, value);
    }

    @JTranscSync
    public static void writeIntBE(byte[] out, int value) {
        JTranscBits.writeIntBE(out, 0, value);
    }

    @JTranscSync
    public static void writeLongBE(byte[] out, long value) {
        JTranscBits.writeLongBE(out, 0, value);
    }

    @JTranscSync
    public static void writeShortLE(byte[] out, short value) {
        JTranscBits.writeShortLE(out, 0, value);
    }

    @JTranscSync
    public static void writeIntLE(byte[] out, int value) {
        JTranscBits.writeIntLE(out, 0, value);
    }

    @JTranscSync
    public static void writeLongLE(byte[] out, long value) {
        JTranscBits.writeLongLE(out, 0, value);
    }

    @JTranscSync
    public static void writeFloatLE(byte[] out, float value) {
        JTranscBits.writeFloatLE(out, 0, value);
    }

    @JTranscSync
    public static void writeDoubleLE(byte[] out, double value) {
        JTranscBits.writeDoubleLE(out, 0, value);
    }

    @JTranscSync
    public static void writeShort(byte[] out, short value) {
        JTranscBits.writeShortBE(out, value);
    }

    @JTranscSync
    public static void writeInt(byte[] out, int value) {
        JTranscBits.writeIntBE(out, value);
    }

    @JTranscSync
    public static void writeLong(byte[] out, long value) {
        JTranscBits.writeLongBE(out, value);
    }

    @JTranscSync
    public static void writeShort(byte[] out, int offset, short value, boolean isLittleEndian) {
        if (isLittleEndian) {
            JTranscBits.writeShortLE(out, offset, value);
        } else {
            JTranscBits.writeShortBE(out, offset, value);
        }
    }

    @JTranscSync
    public static void writeChar(byte[] out, int offset, char value, boolean isLittleEndian) {
        if (isLittleEndian) {
            JTranscBits.writeShortLE(out, offset, (short)value);
        } else {
            JTranscBits.writeShortBE(out, offset, (short)value);
        }
    }

    @JTranscSync
    public static void writeInt(byte[] out, int offset, int value, boolean isLittleEndian) {
        if (isLittleEndian) {
            JTranscBits.writeIntLE(out, offset, value);
        } else {
            JTranscBits.writeIntBE(out, offset, value);
        }
    }

    @JTranscSync
    public static void writeFloat(byte[] out, int offset, float value, boolean isLittleEndian) {
        if (isLittleEndian) {
            JTranscBits.writeIntLE(out, offset, Float.floatToRawIntBits(value));
        } else {
            JTranscBits.writeIntBE(out, offset, Float.floatToRawIntBits(value));
        }
    }

    @JTranscSync
    public static void writeLong(byte[] out, int offset, long value, boolean isLittleEndian) {
        if (isLittleEndian) {
            JTranscBits.writeLongLE(out, offset, value);
        } else {
            JTranscBits.writeLongBE(out, offset, value);
        }
    }

    @JTranscSync
    public static void writeDouble(byte[] out, int offset, double value, boolean isLittleEndian) {
        if (isLittleEndian) {
            JTranscBits.writeLongLE(out, offset, Double.doubleToRawLongBits(value));
        } else {
            JTranscBits.writeLongBE(out, offset, Double.doubleToRawLongBits(value));
        }
    }

    @JTranscSync
    public static int addUint(int base, int offset) {
        int out = base + offset;
        return out >= 0 ? out : Integer.MAX_VALUE;
    }

    @JTranscMethodBody(target="js", value={"return N.isLittleEndian;"})
    @JTranscSync
    public static boolean isLittleEndian() {
        return true;
    }

    @JTranscSync
    public static int mask(int bits) {
        return (1 << bits) - 1;
    }

    @JTranscSync
    public static long lowMask(String chars) {
        int n = chars.length();
        long m = 0L;
        for (int i = 0; i < n; ++i) {
            char c = chars.charAt(i);
            if (c >= '@') continue;
            m |= 1L << c;
        }
        return m;
    }

    @JTranscSync
    public static long highMask(String chars) {
        int n = chars.length();
        long m = 0L;
        for (int i = 0; i < n; ++i) {
            char c = chars.charAt(i);
            if (c < '@' || c >= '\u0080') continue;
            m |= 1L << c - 64;
        }
        return m;
    }

    @JTranscSync
    public static long lowMask(char first, char last) {
        long m = 0L;
        int f = Math.max(Math.min(first, 63), 0);
        int l = Math.max(Math.min(last, 63), 0);
        for (int i = f; i <= l; ++i) {
            m |= 1L << i;
        }
        return m;
    }

    @JTranscSync
    public static long highMask(char first, char last) {
        long m = 0L;
        int f = Math.max(Math.min(first, 127), 64) - 64;
        int l = Math.max(Math.min(last, 127), 64) - 64;
        for (int i = f; i <= l; ++i) {
            m |= 1L << i;
        }
        return m;
    }

    @JTranscSync
    public static byte[] getInt64BE(byte[] data, long v) {
        data[0] = (byte)(v >> 56);
        data[1] = (byte)(v >> 48);
        data[2] = (byte)(v >> 40);
        data[3] = (byte)(v >> 32);
        data[4] = (byte)(v >> 24);
        data[5] = (byte)(v >> 16);
        data[6] = (byte)(v >> 8);
        data[7] = (byte)(v >> 0);
        return data;
    }

    @JTranscSync
    public static byte[] getInt32BE(byte[] data, int v) {
        data[0] = (byte)(v >> 24);
        data[1] = (byte)(v >> 16);
        data[2] = (byte)(v >> 8);
        data[3] = (byte)(v >> 0);
        return data;
    }

    @JTranscSync
    public static byte[] getInt16BE(byte[] data, short v) {
        data[0] = (byte)(v >> 8);
        data[1] = (byte)(v >> 0);
        return data;
    }

    @JTranscSync
    public static byte[] getInt8BE(byte[] data, byte v) {
        data[0] = v;
        return data;
    }

    @JTranscSync
    public static short readInt16BE(byte[] data, int offset) {
        return (short)((data[offset + 0] & 0xFF) << 8 | (data[offset + 1] & 0xFF) << 0);
    }

    @JTranscSync
    public static int readInt32BE(byte[] data, int offset) {
        return (data[offset + 0] & 0xFF) << 24 | (data[offset + 1] & 0xFF) << 16 | (data[offset + 2] & 0xFF) << 8 | (data[offset + 3] & 0xFF) << 0;
    }

    @JTranscSync
    public static long readInt64BE(byte[] data, int offset) {
        return (long)(data[offset + 0] & 0xFF) << 56 | (long)(data[offset + 1] & 0xFF) << 48 | (long)(data[offset + 2] & 0xFF) << 40 | (long)(data[offset + 3] & 0xFF) << 32 | (long)(data[offset + 4] & 0xFF) << 24 | (long)(data[offset + 5] & 0xFF) << 16 | (long)(data[offset + 6] & 0xFF) << 8 | (long)(data[offset + 7] & 0xFF) << 0;
    }

    @JTranscSync
    public static short readInt16BE(byte[] data) {
        return JTranscBits.readInt16BE(data, 0);
    }

    @JTranscSync
    public static int readInt32BE(byte[] data) {
        return JTranscBits.readInt32BE(data, 0);
    }

    @JTranscSync
    public static long readInt64BE(byte[] data) {
        return JTranscBits.readInt64BE(data, 0);
    }

    @JTranscSync
    public static short readInt16(byte[] data, int offset, boolean LE) {
        return LE ? JTranscBits.readInt16LE(data, offset) : JTranscBits.readInt16BE(data, offset);
    }

    @JTranscSync
    public static short readInt16LE(byte[] data, int offset) {
        return (short)((data[offset + 1] & 0xFF) << 8 | (data[offset + 0] & 0xFF) << 0);
    }

    @JTranscSync
    public static int readInt32LE(byte[] data, int offset) {
        return (data[offset + 3] & 0xFF) << 24 | (data[offset + 2] & 0xFF) << 16 | (data[offset + 1] & 0xFF) << 8 | (data[offset + 0] & 0xFF) << 0;
    }

    @JTranscSync
    public static long readInt64LE(byte[] data, int offset) {
        return (long)(data[offset + 7] & 0xFF) << 56 | (long)(data[offset + 6] & 0xFF) << 48 | (long)(data[offset + 5] & 0xFF) << 40 | (long)(data[offset + 4] & 0xFF) << 32 | (long)(data[offset + 3] & 0xFF) << 24 | (long)(data[offset + 2] & 0xFF) << 16 | (long)(data[offset + 1] & 0xFF) << 8 | (long)(data[offset + 0] & 0xFF) << 0;
    }

    @JTranscSync
    public static int clamp(int v, int min, int max) {
        if (v < min) {
            return min;
        }
        if (v > max) {
            return max;
        }
        return v;
    }

    @JTranscInline
    @HaxeMethodBodyList(value={@HaxeMethodBody(target="flash", value="return flash.Memory.signExtend1(p0);")})
    @JTranscSync
    public static int sxi1(int value) {
        return value << 31 >> 31;
    }

    @JTranscInline
    @HaxeMethodBodyList(value={@HaxeMethodBody(target="flash", value="return flash.Memory.signExtend8(p0);"), @HaxeMethodBody(value="return N.i2b(p0);")})
    @JTranscSync
    public static int sxi8(int value) {
        return value << 24 >> 24;
    }

    @JTranscInline
    @HaxeMethodBodyList(value={@HaxeMethodBody(target="flash", value="return flash.Memory.signExtend16(p0);"), @HaxeMethodBody(value="return N.i2s(p0);")})
    @JTranscSync
    public static int sxi16(int value) {
        return value << 16 >> 16;
    }

    @JTranscAsync
    public static short readInt16(ByteBuffer in, boolean LE) {
        int _0 = in.get() & 0xFF;
        int _1 = in.get() & 0xFF;
        return (short)(LE ? _1 << 8 | _0 << 0 : _0 << 8 | _1 << 0);
    }

    @JTranscSync
    public static char reverseBytes(char value) {
        return Character.reverseBytes(value);
    }

    @JTranscSync
    public static short reverseBytes(short value) {
        return Short.reverseBytes(value);
    }

    @JTranscSync
    public static int reverseBytes(int value) {
        return Integer.reverseBytes(value);
    }

    @JTranscSync
    public static long reverseBytes(long value) {
        return Long.reverseBytes(value);
    }
}

