/*
 * Decompiled with CFR 0.152.
 */
package com.jtransc;

import com.jtransc.FastMemory;
import com.jtransc.annotation.JTranscSync;

public class JTranscEndian {
    private static boolean calculated = false;
    private static boolean _le = false;

    @JTranscSync
    private static void calculateOnce() {
        if (calculated) {
            return;
        }
        FastMemory m = FastMemory.alloc(4);
        m.setAlignedInt32(0, 0);
        m.setAlignedInt8(0, 1);
        _le = m.getAlignedInt32(0) == 1;
        calculated = true;
    }

    @JTranscSync
    public static boolean isLittleEndian() {
        JTranscEndian.calculateOnce();
        return _le;
    }

    @JTranscSync
    public static boolean isBigEndian() {
        JTranscEndian.calculateOnce();
        return !_le;
    }

    @JTranscSync
    public static short int16LE(short value) {
        return JTranscEndian.isLittleEndian() ? value : Short.reverseBytes(value);
    }

    @JTranscSync
    public static int int32LE(int value) {
        return JTranscEndian.isLittleEndian() ? value : Integer.reverseBytes(value);
    }

    @JTranscSync
    public static long int64LE(long value) {
        return JTranscEndian.isLittleEndian() ? value : Long.reverseBytes(value);
    }
}

