/*
 * Decompiled with CFR 0.152.
 */
package com.jtransc;

import com.jtransc.JTranscSystem;
import com.jtransc.annotation.JTranscSync;

public class JTranscSystemProperties {
    @JTranscSync
    public static String fileEncoding() {
        return "UTF-8";
    }

    @JTranscSync
    public static String userLanguage() {
        return "en";
    }

    @JTranscSync
    public static String userRegion() {
        return "US";
    }

    @JTranscSync
    public static String userVariant() {
        return "";
    }

    public static String tmpdir() {
        String out = JTranscSystemProperties.getenvs(new String[]{"TMPDIR", "TEMP", "TMP"}, "/tmp");
        if (!(!JTranscSystem.isWindows() || out.endsWith("/") && out.endsWith("\\"))) {
            out = out + "\\";
        }
        return out;
    }

    public static String getenvs(String[] names, String defaultValue) {
        for (String name : names) {
            String out = System.getenv(name);
            if (out == null) continue;
            return out;
        }
        return defaultValue;
    }

    public static String userHome() {
        return JTranscSystemProperties.getenvs(new String[]{"HOME"}, "/tmp");
    }

    public static String userDir() {
        return JTranscSystemProperties.getenvs(new String[]{"HOME"}, "/tmp");
    }

    public static String userName() {
        return JTranscSystemProperties.getenvs(new String[]{"USERNAME", "USER"}, "username");
    }

    @JTranscSync
    public static String javaHome() {
        return "/tmp";
    }

    @JTranscSync
    public static String fileSeparator() {
        return "/";
    }

    @JTranscSync
    public static String pathSeparator() {
        return ":";
    }

    @JTranscSync
    public static String lineSeparator() {
        return "\n";
    }
}

