/*
 * Decompiled with CFR 0.152.
 */
package com.jtransc.charset;

import com.jtransc.annotation.JTranscAsync;
import com.jtransc.annotation.JTranscSync;
import com.jtransc.charset.JTranscCharBuffer;
import com.jtransc.ds.FastStringMap;
import java.io.ByteArrayOutputStream;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.UnsupportedCharsetException;
import java.util.Collections;
import java.util.HashSet;
import java.util.ServiceLoader;
import java.util.Set;

public abstract class JTranscCharset {
    private final String[] names;
    private final int min;
    private final float avg;
    private final int max;
    private static FastStringMap<JTranscCharset> charsets = new FastStringMap();
    private static JTranscCharset _defaultCharset;

    @JTranscSync
    public final float minBytesPerCharacter() {
        return this.min;
    }

    @JTranscSync
    public final float avgBytesPerCharacter() {
        return this.avg;
    }

    @JTranscSync
    public final float maxBytesPerCharacter() {
        return this.max;
    }

    @JTranscSync
    public final String getCannonicalName() {
        return this.names[0];
    }

    @JTranscSync
    public JTranscCharset(String[] names, int min, float avg, int max) {
        this.names = names;
        this.min = min;
        this.avg = avg;
        this.max = max;
    }

    @JTranscSync
    public final String[] getAliases() {
        return this.names;
    }

    @JTranscSync
    public abstract void encode(char[] var1, int var2, int var3, ByteArrayOutputStream var4);

    @JTranscSync
    public abstract void decode(byte[] var1, int var2, int var3, JTranscCharBuffer var4);

    @JTranscAsync
    public abstract void decode(ByteBuffer var1, CharBuffer var2);

    @JTranscSync
    public final byte[] encode(String str) {
        ByteArrayOutputStream out = new ByteArrayOutputStream((int)((float)str.length() * this.avgBytesPerCharacter()));
        this.encode(str.toCharArray(), 0, str.length(), out);
        return out.toByteArray();
    }

    @JTranscSync
    public final String decode(byte[] data, int offset, int len) {
        JTranscCharBuffer out = new JTranscCharBuffer((int)((float)data.length / this.avgBytesPerCharacter()));
        this.decode(data, offset, len, out);
        return out.toString();
    }

    @JTranscSync
    public final String decode(byte[] data) {
        return this.decode(data, 0, data.length);
    }

    @JTranscSync
    public final char[] decodeChars(byte[] data) {
        return this.decode(data).toCharArray();
    }

    @JTranscSync
    public final char[] decodeChars(byte[] data, int offset, int len) {
        return this.decode(data, offset, len).toCharArray();
    }

    @JTranscSync
    public static JTranscCharset[] getSupportedCharsets() {
        return charsets.getValues();
    }

    @JTranscAsync
    public static Set<JTranscCharset> getSupportedCharsetsSet() {
        JTranscCharset[] supportedCharsets = JTranscCharset.getSupportedCharsets();
        HashSet<JTranscCharset> out = new HashSet<JTranscCharset>();
        Collections.addAll(out, supportedCharsets);
        return out;
    }

    @JTranscSync
    public static JTranscCharset forName(String name) {
        JTranscCharset charset = charsets.get(name.toUpperCase().trim());
        if (charset == null) {
            throw new UnsupportedCharsetException(name);
        }
        return charset;
    }

    @JTranscSync
    public static JTranscCharset defaultCharset() {
        if (_defaultCharset == null) {
            _defaultCharset = JTranscCharset.forName("UTF-8");
        }
        return _defaultCharset;
    }

    static {
        for (JTranscCharset c : ServiceLoader.load(JTranscCharset.class)) {
            for (String alias : c.getAliases()) {
                charsets.set(alias.toUpperCase().trim(), c);
            }
        }
    }
}

