/*
 * Decompiled with CFR 0.152.
 */
package com.jtransc.charset;

import com.jtransc.annotation.JTranscAsync;
import com.jtransc.annotation.JTranscSync;
import com.jtransc.charset.JTranscCharBuffer;
import com.jtransc.charset.JTranscCharset;
import com.jtransc.ds.FastIntIntMap;
import java.io.ByteArrayOutputStream;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;

public class JTranscCharsetSingleByte
extends JTranscCharset {
    final String decode;
    final FastIntIntMap encode;
    final byte invalidChar = (byte)63;

    @JTranscSync
    public JTranscCharsetSingleByte(String[] aliases, String chars) {
        super(aliases, 1, 1.0f, 1);
        this.decode = chars;
        this.encode = new FastIntIntMap();
        for (int n = 0; n < chars.length(); ++n) {
            this.encode.set(chars.charAt(n), n);
        }
    }

    @Override
    @JTranscSync
    public final void encode(char[] in, int offset, int len, ByteArrayOutputStream out) {
        for (int n = 0; n < len; ++n) {
            char c = in[offset + n];
            if (this.encode.has(c)) {
                out.write(this.encode.get(c));
                continue;
            }
            out.write(63);
        }
    }

    @Override
    @JTranscSync
    public final void decode(byte[] in, int offset, int len, JTranscCharBuffer out) {
        for (int n = 0; n < len; ++n) {
            int b = in[offset + n] & 0xFF;
            out.append(this.decode.charAt(b));
        }
    }

    @Override
    @JTranscAsync
    public final void decode(ByteBuffer in, CharBuffer out) {
        while (in.hasRemaining() && out.hasRemaining()) {
            int b = in.get() & 0xFF;
            out.append(this.decode.charAt(b));
        }
    }
}

