/*
 * Decompiled with CFR 0.152.
 */
package com.jtransc.charset;

import com.jtransc.JTranscBits;

public class ModifiedUtf8 {
    public static int countBytes(String str, boolean slen) {
        return ModifiedUtf8.countBytes(str);
    }

    public static int countBytes(String str) {
        int result = 0;
        int length = str.length();
        for (int n = 0; n < length; ++n) {
            char c = str.charAt(n);
            if (c == '\u0000') {
                result += 2;
                continue;
            }
            if (c > '\u0000' && c < '\u0080') {
                ++result;
                continue;
            }
            if (c < '\u0800') {
                result += 2;
                continue;
            }
            result += 3;
        }
        return result;
    }

    public static void encode(byte[] out, int offset, String str) {
        int len = str.length();
        int pos = offset;
        for (int n = 0; n < len; ++n) {
            char c = str.charAt(n);
            if (c == '\u0000') {
                out[pos++] = -64;
                out[pos++] = -128;
                continue;
            }
            if (c > '\u0000' && c < '\u0080') {
                out[pos++] = (byte)c;
                continue;
            }
            if (c < '\u0800') {
                out[pos++] = (byte)(0xC0 | 0x1F & c >> 6);
                out[pos++] = (byte)(0x80 | 0x3F & c >> 0);
                continue;
            }
            out[pos++] = (byte)(0xE0 | 0xF & c >> 12);
            out[pos++] = (byte)(0x80 | 0x3F & c >> 6);
            out[pos++] = (byte)(0x80 | 0x3F & c >> 0);
        }
    }

    public static byte[] encode(String str) {
        int bytesSize = ModifiedUtf8.countBytes(str);
        byte[] out = new byte[2 + bytesSize];
        JTranscBits.writeShortBE(out, 0, (short)bytesSize);
        ModifiedUtf8.encode(out, 2, str);
        return out;
    }

    public static String decode(byte[] in, int offset, int len) {
        StringBuilder out = new StringBuilder();
        int pos = offset;
        int end = offset + len;
        while (pos < end) {
            byte c1;
            char c0;
            if ((c0 = (char)in[pos++]) < '\u0080') {
                out.append(c0);
                continue;
            }
            if ((c0 & 0xE0) == 192) {
                if (pos >= end || ((c1 = in[pos++]) & 0xC0) != 128) break;
                out.append((char)((c0 & 0x1F) << 6 | c1 & 0x3F));
                continue;
            }
            if ((c0 & 0xF0) != 224 || pos + 1 >= end) break;
            c1 = in[pos++];
            byte c2 = in[pos++];
            if ((c1 & 0xC0) != 128 || (c2 & 0xC0) != 128) break;
            out.append((char)((c0 & 0xF) << 12 | (c1 & 0x3F) << 6 | c2 & 0x3F));
        }
        return out.toString();
    }

    public static String decode(byte[] in, char[] temp, int offset, int len) {
        return ModifiedUtf8.decode(in, offset, len);
    }

    public static String decode(byte[] in) {
        return ModifiedUtf8.decode(in, 0, in.length);
    }

    public static String decodeLen(byte[] in, int offset) {
        int len = JTranscBits.readInt16BE(in, offset) & 0xFFFF;
        return ModifiedUtf8.decode(in, offset + 2, len);
    }

    public static String decodeLen(byte[] in) {
        return ModifiedUtf8.decodeLen(in, 0);
    }
}

