/*
 * Decompiled with CFR 0.152.
 */
package com.jtransc.io;

import com.jtransc.annotation.JTranscMethodBody;
import com.jtransc.io.JTranscConsole;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;

public class JTranscConsolePrintStream
extends PrintStream {
    final boolean error;
    final ConsoleStream stream;

    public JTranscConsolePrintStream(boolean error) {
        this(new ConsoleStream(error), error);
    }

    private JTranscConsolePrintStream(ConsoleStream stream, boolean error) {
        super(stream);
        this.stream = stream;
        this.error = error;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void println(String x) {
        JTranscConsolePrintStream jTranscConsolePrintStream = this;
        synchronized (jTranscConsolePrintStream) {
            JTranscConsole.logOrError(this.stream.sb.toString() + x, this.error);
            this.stream.sb.setLength(0);
        }
    }

    private static class ConsoleStream
    extends OutputStream {
        public final StringBuilder sb = new StringBuilder();
        private final boolean error;

        public ConsoleStream(boolean error) {
            this.error = error;
        }

        protected void _write(char c) throws IOException {
            if (c == '\n') {
                JTranscConsole.logOrError(this.sb.toString(), this.error);
                this.sb.setLength(0);
            } else {
                this.sb.append(c);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @JTranscMethodBody(target="dart", value={"if (this{% IFIELD #CLASS:error %}) stderr.writeCharCode(p0); else stdout.writeCharCode(p0);"})
        public void write(int b) throws IOException {
            ConsoleStream consoleStream = this;
            synchronized (consoleStream) {
                this._write((char)b);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            ConsoleStream consoleStream = this;
            synchronized (consoleStream) {
                super.write(b, off, len);
            }
        }
    }
}

