/*
 * Decompiled with CFR 0.152.
 */
package com.jtransc.io;

import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class JTranscIoTools {
    private static final int EOF = -1;

    public static synchronized byte[] readStreamFully(InputStream ios) {
        int length = 0;
        try {
            int readed;
            length = ios.available();
            byte[] out = new byte[length];
            for (int offset = 0; offset < length; offset += readed) {
                readed = ios.read(out, offset, length - offset);
                if (readed >= 0) continue;
                throw new IOException("Can't read file");
            }
            ios.close();
            return out;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static synchronized byte[] readFile(File file) throws IOException {
        try (FileInputStream fis = new FileInputStream(file);){
            byte[] byArray = JTranscIoTools.readStreamFully(fis);
            return byArray;
        }
    }

    public static synchronized void writeFile(File file, byte[] data) throws IOException {
        try (FileOutputStream fos = new FileOutputStream(file);){
            fos.write(data);
        }
    }

    public static <TOutputStream extends OutputStream> TOutputStream copy(InputStream is, TOutputStream os) throws IOException {
        JTranscIoTools.copyLarge(is, os, new byte[65536]);
        return os;
    }

    public static long copyLarge(InputStream input, OutputStream output, byte[] buffer) throws IOException {
        int n;
        long count = 0L;
        while (-1 != (n = input.read(buffer))) {
            output.write(buffer, 0, n);
            count += (long)n;
        }
        return count;
    }

    public static void closeQuietly(Closeable closeable) {
        try {
            closeable.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static synchronized long skipByReading(InputStream in, long byteCount) throws IOException {
        int toRead;
        long skipped;
        int read;
        byte[] buffer = new byte[4096];
        for (skipped = 0L; skipped < byteCount && (read = in.read(buffer, 0, toRead = (int)Math.min(byteCount - skipped, (long)buffer.length))) != -1; skipped += (long)read) {
            if (read >= toRead) continue;
            break;
        }
        return skipped;
    }

    public static synchronized void readFully(InputStream in, byte[] out, int offset, int length) throws IOException {
        int readed;
        for (int left = length; left > 0; left -= readed) {
            readed = in.read(out, offset, left);
            if (readed < 0) {
                throw new IOException();
            }
            offset += readed;
        }
    }
}

