/*
 * Decompiled with CFR 0.152.
 */
package com.jtransc.mem;

import com.jtransc.annotation.JTranscSync;

public class BytesRead {
    @JTranscSync
    private static int _u8(byte[] data, int offset) {
        return data[offset] & 0xFF;
    }

    @JTranscSync
    private static int _u16(byte[] data, int offset) {
        return BytesRead._u8(data, offset + 1) << 0 | BytesRead._u8(data, offset + 0) << 8;
    }

    @JTranscSync
    private static int _s32(byte[] data, int offset) {
        return BytesRead._u16(data, offset + 2) << 0 | BytesRead._u16(data, offset + 0) << 16;
    }

    @JTranscSync
    private static long _u32(byte[] data, int offset) {
        return (long)BytesRead._s32(data, offset) & 0xFFFFFFFFL;
    }

    @JTranscSync
    private static long _s64(byte[] data, int offset) {
        return BytesRead._u32(data, offset + 4) << 0 | BytesRead._u32(data, offset + 0) << 32;
    }

    @JTranscSync
    public static int u8l(byte[] data, int offset) {
        return BytesRead._u8(data, offset);
    }

    @JTranscSync
    public static int u8b(byte[] data, int offset) {
        return BytesRead._u8(data, offset);
    }

    @JTranscSync
    public static int u16l(byte[] data, int offset) {
        return Short.reverseBytes((short)BytesRead._u16(data, offset)) & 0xFFFF;
    }

    @JTranscSync
    public static int u16b(byte[] data, int offset) {
        return BytesRead._u16(data, offset);
    }

    @JTranscSync
    public static long u32l(byte[] data, int offset) {
        return (long)Integer.reverseBytes(BytesRead._s32(data, offset)) & 0xFFFFFFFFL;
    }

    @JTranscSync
    public static long u32b(byte[] data, int offset) {
        return (long)BytesRead._s32(data, offset) & 0xFFFFFFFFL;
    }

    @JTranscSync
    public static int s8l(byte[] data, int offset) {
        return (byte)BytesRead.u8l(data, offset);
    }

    @JTranscSync
    public static int s8b(byte[] data, int offset) {
        return (byte)BytesRead.u8b(data, offset);
    }

    @JTranscSync
    public static int s16l(byte[] data, int offset) {
        return (short)BytesRead.u16l(data, offset);
    }

    @JTranscSync
    public static int s16b(byte[] data, int offset) {
        return (short)BytesRead.u16b(data, offset);
    }

    @JTranscSync
    public static int s32l(byte[] data, int offset) {
        return Integer.reverseBytes(BytesRead._s32(data, offset));
    }

    @JTranscSync
    public static int s32b(byte[] data, int offset) {
        return BytesRead._s32(data, offset);
    }

    @JTranscSync
    public static long s64l(byte[] data, int offset) {
        return Long.reverseBytes(BytesRead._s64(data, offset));
    }

    @JTranscSync
    public static long s64b(byte[] data, int offset) {
        return BytesRead._s64(data, offset);
    }

    @JTranscSync
    public static float f32l(byte[] data, int offset) {
        return Float.intBitsToFloat(BytesRead.s32l(data, offset));
    }

    @JTranscSync
    public static float f32b(byte[] data, int offset) {
        return Float.intBitsToFloat(BytesRead.s32b(data, offset));
    }

    @JTranscSync
    public static double f64l(byte[] data, int offset) {
        return Double.longBitsToDouble(BytesRead.s64l(data, offset));
    }

    @JTranscSync
    public static double f64b(byte[] data, int offset) {
        return Double.longBitsToDouble(BytesRead.s64b(data, offset));
    }
}

