/*
 * Decompiled with CFR 0.152.
 */
package com.jtransc.text;

import com.jtransc.annotation.JTranscInvisible;
import com.jtransc.annotation.JTranscSync;

@JTranscInvisible
public class MStringReader {
    public final String str;
    public final int length;
    public int offset;

    @JTranscSync
    public MStringReader(String str) {
        this(str, 0);
    }

    @JTranscSync
    public MStringReader(String str, int offset) {
        this.str = str;
        this.length = str.length();
        this.offset = offset;
    }

    @JTranscSync
    public boolean hasMore() {
        return this.offset < this.length;
    }

    @JTranscSync
    public char peek() {
        if (!this.hasMore()) {
            throw new Error("Can't read more");
        }
        return this.str.charAt(this.offset);
    }

    @JTranscSync
    public void skip() {
        this.skip(1);
    }

    @JTranscSync
    public void skip(int count) {
        this.offset += count;
    }

    @JTranscSync
    public void expect(char c) {
        if (!this.hasMore()) {
            throw new Error("Expected " + c + " but found end");
        }
        if (this.read() != c) {
            throw new Error("Expected " + c);
        }
    }

    @JTranscSync
    public char read() {
        if (!this.hasMore()) {
            throw new Error("Can't read more");
        }
        char out = this.peek();
        this.skip();
        return out;
    }

    @JTranscSync
    public int available() {
        return this.length - this.offset;
    }

    @JTranscSync
    public String read(int count) {
        int c = Math.min(count, this.available());
        String out = this.str.substring(this.offset, this.offset + c);
        this.skip(c);
        return out;
    }

    @JTranscSync
    public String readUntil(char c, boolean include) {
        return this.readUntil(c, c, c, include);
    }

    @JTranscSync
    public String readUntil(char c, char c2, boolean include) {
        return this.readUntil(c, c2, c2, include);
    }

    @JTranscSync
    public String readUntil(char c, char c2, char c3, boolean include) {
        int start = this.offset;
        while (this.hasMore()) {
            char r = this.read();
            if (r != c && r != c2 && r != c3) continue;
            if (include) break;
            this.skip(-1);
            break;
        }
        return this.str.substring(start, this.offset);
    }
}

