/*
 * Decompiled with CFR 0.152.
 */
package j;

import com.jtransc.annotation.JTranscAsync;
import com.jtransc.annotation.JTranscSync;
import com.jtransc.ds.FastIntMap;
import com.jtransc.ds.FastStringMap;
import com.jtransc.io.JTranscConsole;
import j.ClassInfo;
import j.MemberInfo;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;

public class ProgramReflection {
    public static ClassInfo[] _classInfos;
    public static String[] _classNames;
    public static FastStringMap<ClassInfo> _classInfosByName;
    private static final FastIntMap<FastIntMap<MemberInfo>> _directMethodsInfo;
    private static boolean _ensureMethodsDone;

    @JTranscSync
    public static void _ensure() {
        if (_classInfos != null) {
            return;
        }
        _classInfosByName = new FastStringMap();
        _classInfos = ProgramReflection.getAllClasses();
        if (_classInfos != null) {
            _classNames = new String[_classInfos.length];
            for (ClassInfo info : _classInfos) {
                if (info == null) continue;
                _classInfosByName.set(info.name, info);
                ProgramReflection._classNames[info.id] = info.name;
            }
        }
    }

    @JTranscSync
    public static void _ensureMethods() {
        if (_ensureMethodsDone) {
            return;
        }
        ProgramReflection._ensure();
        for (ClassInfo info : _classInfos) {
            if (info == null) continue;
            FastIntMap<MemberInfo> map = new FastIntMap<MemberInfo>();
            _directMethodsInfo.set(info.id, map);
            MemberInfo[] minfo = ProgramReflection.getMethods(info.id);
            if (minfo == null) continue;
            for (MemberInfo i : minfo) {
                map.set(i.id, i);
            }
        }
        _ensureMethodsDone = true;
    }

    @JTranscSync
    public static boolean hasClassWithName(String name) {
        ProgramReflection._ensure();
        return _classInfosByName.has(name);
    }

    @JTranscSync
    public static ClassInfo getClassInfoWithName(String name) {
        ProgramReflection._ensure();
        return ProgramReflection.hasClassWithName(name) ? _classInfosByName.get(name) : null;
    }

    @JTranscSync
    public static ClassInfo[] getAllClasses() {
        return _classInfos != null ? _classInfos : AllClasses.getAllClasses();
    }

    @JTranscSync
    public static MemberInfo[] getConstructors(int classId) {
        return AllConstructors.getConstructors(classId);
    }

    @JTranscSync
    public static MemberInfo[] getMethods(int classId) {
        return AllMethods.getMethods(classId);
    }

    @JTranscSync
    public static MemberInfo[] getFields(int classId) {
        return AllFields.getFields(classId);
    }

    @JTranscAsync
    public static Object dynamicNew(int classId, int constructorId, Object[] params) {
        return DynamicNew.dynamicNew(classId, constructorId, params);
    }

    @JTranscAsync
    public static Object dynamicInvoke(int classId, int methodId, Object object, Object[] params) {
        return DynamicInvoke.dynamicInvoke(classId, methodId, object, params);
    }

    @JTranscSync
    public static Object dynamicGet(int classId, int fieldId, Object object) {
        return DynamicGet.dynamicGet(classId, fieldId, object);
    }

    @JTranscSync
    public static void dynamicSet(int classId, int fieldId, Object object, Object value) {
        DynamicSet.dynamicSet(classId, fieldId, object, value);
    }

    @JTranscSync
    public static Annotation[] getClassAnnotations(int classId) {
        return new Annotation[0];
    }

    @JTranscSync
    public static Annotation[] getFieldAnnotations(int classId, int fieldId) {
        return new Annotation[0];
    }

    @JTranscSync
    public static Annotation[] getMethodAnnotations(int classId, int methodId) {
        return new Annotation[0];
    }

    @JTranscSync
    public static Annotation[] getMethodArgumentAnnotations(int classId, int methodId, int argIndex) {
        return new Annotation[0];
    }

    @JTranscSync
    public static MemberInfo getMethodInfo(int classId, int methodId) {
        ProgramReflection._ensureMethods();
        return _directMethodsInfo.get(classId).get(methodId);
    }

    @JTranscSync
    public static native Method getMethodByInfo(Class<?> var0, MemberInfo var1);

    @JTranscSync
    public static Class<?> getClassById(int classId) {
        ProgramReflection._ensure();
        try {
            return Class.forName(_classNames[classId]);
        }
        catch (ClassNotFoundException e) {
            JTranscConsole.syncPrintStackTrace(e);
            return null;
        }
    }

    @JTranscSync
    public static Method getDirectMethod(int classId, int methodId) {
        return ProgramReflection.getMethodByInfo(ProgramReflection.getClassById(classId), ProgramReflection.getMethodInfo(classId, methodId));
    }

    static {
        _directMethodsInfo = new FastIntMap();
        _ensureMethodsDone = false;
    }

    public static class DynamicSet {
        @JTranscSync
        public static void dynamicSet(int classId, int fieldId, Object object, Object value) {
        }
    }

    public static class DynamicGet {
        @JTranscSync
        public static Object dynamicGet(int classId, int fieldId, Object object) {
            return null;
        }
    }

    public static class DynamicInvokeLast {
        @JTranscAsync
        public static Object dynamicInvoke(int classId, int methodId, Object object, Object[] params) {
            return null;
        }
    }

    public static class DynamicInvokeMiddle {
        @JTranscAsync
        public static Object dynamicInvoke(int classId, int methodId, Object object, Object[] params) {
            return null;
        }
    }

    public static class DynamicInvokeFirst {
        @JTranscAsync
        public static Object dynamicInvoke(int classId, int methodId, Object object, Object[] params) {
            return null;
        }
    }

    public static class DynamicInvoke {
        @JTranscAsync
        public static Object dynamicInvoke(int classId, int methodId, Object object, Object[] params) {
            Object ret = DynamicInvokeFirst.dynamicInvoke(classId, methodId, object, params);
            if (ret != null) {
                return ret;
            }
            ret = DynamicInvokeMiddle.dynamicInvoke(classId, methodId, object, params);
            if (ret != null) {
                return ret;
            }
            return DynamicInvokeLast.dynamicInvoke(classId, methodId, object, params);
        }
    }

    public static class DynamicNew {
        @JTranscAsync
        public static Object dynamicNew(int classId, int constructorId, Object[] params) {
            return null;
        }
    }

    public static class AllFieldsLast {
        @JTranscSync
        public AllFieldsLast() {
        }

        @JTranscSync
        public static MemberInfo[] getFields(int classId) {
            return new MemberInfo[0];
        }
    }

    public static class AllFieldsMiddle {
        @JTranscSync
        public AllFieldsMiddle() {
        }

        @JTranscSync
        public static MemberInfo[] getFields(int classId) {
            return new MemberInfo[0];
        }
    }

    public static class AllFieldsFirst {
        @JTranscSync
        public AllFieldsFirst() {
        }

        @JTranscSync
        public static MemberInfo[] getFields(int classId) {
            return new MemberInfo[0];
        }
    }

    public static class AllFields {
        @JTranscSync
        public AllFields() {
        }

        @JTranscSync
        public static MemberInfo[] getFields(int classId) {
            MemberInfo[] ret = AllFieldsFirst.getFields(classId);
            if (ret != null && ret.length > 0) {
                return ret;
            }
            ret = AllFieldsMiddle.getFields(classId);
            if (ret != null && ret.length > 0) {
                return ret;
            }
            return AllFieldsLast.getFields(classId);
        }
    }

    public static class AllMethodsLast {
        @JTranscSync
        public AllMethodsLast() {
        }

        @JTranscSync
        public static MemberInfo[] getMethods(int classId) {
            return new MemberInfo[0];
        }
    }

    public static class AllMethodsMiddle {
        @JTranscSync
        public AllMethodsMiddle() {
        }

        @JTranscSync
        public static MemberInfo[] getMethods(int classId) {
            return new MemberInfo[0];
        }
    }

    public static class AllMethodsFirst {
        @JTranscSync
        public AllMethodsFirst() {
        }

        @JTranscSync
        public static MemberInfo[] getMethods(int classId) {
            return new MemberInfo[0];
        }
    }

    public static class AllMethods {
        @JTranscSync
        public AllMethods() {
        }

        @JTranscSync
        public static MemberInfo[] getMethods(int classId) {
            MemberInfo[] ret = AllMethodsFirst.getMethods(classId);
            if (ret != null && ret.length > 0) {
                return ret;
            }
            ret = AllMethodsMiddle.getMethods(classId);
            if (ret != null && ret.length > 0) {
                return ret;
            }
            return AllMethodsLast.getMethods(classId);
        }
    }

    public static class AllConstructorsLast {
        @JTranscSync
        public static MemberInfo[] getConstructors(int classId) {
            return new MemberInfo[0];
        }
    }

    public static class AllConstructorsMiddle {
        @JTranscSync
        public static MemberInfo[] getConstructors(int classId) {
            return new MemberInfo[0];
        }
    }

    public static class AllConstructorsFirst {
        @JTranscSync
        public static MemberInfo[] getConstructors(int classId) {
            return new MemberInfo[0];
        }
    }

    public static class AllConstructors {
        @JTranscSync
        public static MemberInfo[] getConstructors(int classId) {
            MemberInfo[] ret = AllConstructorsFirst.getConstructors(classId);
            if (ret != null && ret.length > 0) {
                return ret;
            }
            ret = AllConstructorsMiddle.getConstructors(classId);
            if (ret != null && ret.length > 0) {
                return ret;
            }
            return AllConstructorsLast.getConstructors(classId);
        }
    }

    public static class AllClasses {
        public ClassInfo[] test;

        @JTranscSync
        public static ClassInfo[] getAllClasses() {
            ClassInfo[][] classInfoParts = new ClassInfo[][]{AllClasses.getAllClasses3000(), AllClasses.getAllClasses6000(), AllClasses.getAllClasses9000(), AllClasses.getAllClasses12000(), AllClasses.getAllClasses15000(), AllClasses.getAllClassesMax()};
            ClassInfo[] classInfo = new ClassInfo[AllClasses.getAllClassesCount()];
            ClassInfo[][] classInfoArrayArray = classInfoParts;
            int n = classInfoArrayArray.length;
            for (int i = 0; i < n; ++i) {
                ClassInfo[] classInfoPart;
                ClassInfo[] classInfoArray = classInfoPart = classInfoArrayArray[i];
                int n2 = classInfoArray.length;
                for (int j = 0; j < n2; ++j) {
                    ClassInfo aClassInfo;
                    classInfo[aClassInfo.id] = aClassInfo = classInfoArray[j];
                }
            }
            return classInfo;
        }

        @JTranscSync
        public static int getAllClassesCount() {
            return 0;
        }

        @JTranscSync
        public static ClassInfo[] getAllClasses3000() {
            return new ClassInfo[0];
        }

        @JTranscSync
        public static ClassInfo[] getAllClasses6000() {
            return new ClassInfo[0];
        }

        @JTranscSync
        public static ClassInfo[] getAllClasses9000() {
            return new ClassInfo[0];
        }

        @JTranscSync
        public static ClassInfo[] getAllClasses12000() {
            return new ClassInfo[0];
        }

        @JTranscSync
        public static ClassInfo[] getAllClasses15000() {
            return new ClassInfo[0];
        }

        @JTranscSync
        public static ClassInfo[] getAllClassesMax() {
            return new ClassInfo[0];
        }
    }
}

