/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import java.io.DataInput;
import java.io.EOFException;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import jtransc.JTranscBits;
import jtransc.JTranscTempBuffer;

public class DataInputStream
extends FilterInputStream
implements DataInput {
    private static byte[] temp = new byte[8];

    public DataInputStream(InputStream in) {
        super(in);
    }

    @Override
    public final int read(byte[] data) throws IOException {
        return this.in.read(data, 0, data.length);
    }

    @Override
    public final int read(byte[] data, int offset, int length) throws IOException {
        return this.in.read(data, offset, length);
    }

    @Override
    public final void readFully(byte[] data) throws IOException {
        this.readFully(data, 0, data.length);
    }

    @Override
    public final void readFully(byte[] data, int offset, int length) throws IOException {
        int count;
        if (length < 0) {
            throw new IndexOutOfBoundsException();
        }
        for (int n = 0; n < length; n += count) {
            count = this.in.read(data, offset + n, length - n);
            if (count >= 0) continue;
            throw new EOFException();
        }
    }

    @Override
    public final int skipBytes(int n) throws IOException {
        int totalSkipped;
        int currentSkipped;
        for (totalSkipped = 0; totalSkipped < n && (currentSkipped = (int)this.in.skip(n - totalSkipped)) > 0; totalSkipped += currentSkipped) {
        }
        return totalSkipped;
    }

    private int _readUnsignedByte() throws IOException {
        int ch = this.in.read();
        if (ch < 0) {
            throw new EOFException();
        }
        return ch;
    }

    private int _readUnsignedShort() throws IOException {
        this.readFully(temp, 0, 2);
        return JTranscBits.makeShort((byte[])temp);
    }

    private int _readInt() throws IOException {
        this.readFully(temp, 0, 4);
        return JTranscBits.makeInt((byte[])temp);
    }

    @Override
    public final boolean readBoolean() throws IOException {
        return this._readUnsignedByte() != 0;
    }

    @Override
    public final byte readByte() throws IOException {
        return (byte)this._readUnsignedByte();
    }

    @Override
    public final int readUnsignedByte() throws IOException {
        return this._readUnsignedByte();
    }

    @Override
    public final short readShort() throws IOException {
        return (short)this._readUnsignedShort();
    }

    @Override
    public final int readUnsignedShort() throws IOException {
        return this._readUnsignedShort();
    }

    @Override
    public final char readChar() throws IOException {
        return (char)this._readUnsignedShort();
    }

    @Override
    public final int readInt() throws IOException {
        return this._readInt();
    }

    @Override
    public final long readLong() throws IOException {
        byte[] temp = JTranscTempBuffer.tempByte(8);
        this.readFully(temp, 0, 8);
        return JTranscBits.makeLong((byte[])temp);
    }

    @Override
    public final float readFloat() throws IOException {
        return Float.intBitsToFloat(this.readInt());
    }

    @Override
    public final double readDouble() throws IOException {
        return Double.longBitsToDouble(this.readLong());
    }

    @Override
    @Deprecated
    public final native String readLine() throws IOException;

    @Override
    public final String readUTF() throws IOException {
        return DataInputStream.readUTF(this);
    }

    public static String readUTF(DataInput in) throws IOException {
        int len = in.readUnsignedShort();
        byte[] temp = JTranscTempBuffer.tempByte(len);
        in.readFully(temp, 0, len);
        return new String(temp, "utf-8");
    }
}

