/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import java.io.Closeable;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileDescriptor;
import java.io.FileNotFoundException;
import java.io.IOException;
import jtransc.JTranscData;
import jtransc.JTranscIOSync;
import jtransc.JTranscIOSyncFile;

public class RandomAccessFile
implements DataOutput,
DataInput,
Closeable {
    private FileDescriptor fd;
    private boolean rw;
    private final String path;
    private Object closeLock = new Object();
    private volatile boolean closed = false;
    private final JTranscIOSyncFile jfd;
    private byte[] temp = new byte[8];

    public RandomAccessFile(String name, String mode) throws FileNotFoundException {
        this(name != null ? new File(name) : null, mode);
    }

    public RandomAccessFile(File file, String mode) throws FileNotFoundException {
        String name = file != null ? file.getPath() : null;
        int imode = -1;
        if (mode.equals("r")) {
            imode = 1;
        } else if (mode.startsWith("rw")) {
            imode = 2;
            this.rw = true;
            if (mode.length() > 2) {
                if (mode.equals("rws")) {
                    imode |= 4;
                }
                if (mode.equals("rwd")) {
                    imode |= 8;
                }
            }
        }
        if (imode < 0) {
            throw new IllegalArgumentException("Illegal mode \"" + mode + "\" must be one of " + "\"r\", \"rw\", \"rws\"," + " or \"rwd\"");
        }
        if (name == null) {
            throw new NullPointerException();
        }
        if (file.isInvalid()) {
            throw new FileNotFoundException("Invalid file path");
        }
        this.fd = new FileDescriptor();
        this.path = name;
        this.jfd = JTranscIOSync.open(name, imode);
    }

    public final FileDescriptor getFD() throws IOException {
        if (this.fd == null) {
            throw new IOException();
        }
        return this.fd;
    }

    public int read() throws IOException {
        return this.jfd.read();
    }

    public int read(byte[] b, int off, int len) throws IOException {
        return this.jfd.readBytes(b, off, len);
    }

    public int read(byte[] b) throws IOException {
        return this.jfd.readBytes(b, 0, b.length);
    }

    @Override
    public final void readFully(byte[] b) throws IOException {
        this.readFully(b, 0, b.length);
    }

    @Override
    public final void readFully(byte[] b, int off, int len) throws IOException {
        int count;
        int n = 0;
        do {
            if ((count = this.read(b, off + n, len - n)) >= 0) continue;
            throw new EOFException();
        } while ((n += count) < len);
    }

    @Override
    public int skipBytes(int n) throws IOException {
        long len;
        if (n <= 0) {
            return 0;
        }
        long pos = this.getFilePointer();
        long newpos = pos + (long)n;
        if (newpos > (len = this.length())) {
            newpos = len;
        }
        this.seek(newpos);
        return (int)(newpos - pos);
    }

    @Override
    public void write(int b) throws IOException {
        this.jfd.write(b);
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.jfd.writeBytes(b, 0, b.length);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        this.jfd.writeBytes(b, off, len);
    }

    public long getFilePointer() throws IOException {
        return this.jfd.getFilePointer();
    }

    public void seek(long pos) throws IOException {
        if (pos < 0L) {
            throw new IOException("Negative seek offset");
        }
        this.jfd.seek(pos);
    }

    public long length() throws IOException {
        return this.jfd.length();
    }

    public void setLength(long newLength) throws IOException {
        this.jfd.setLength(newLength);
    }

    @Override
    public void close() throws IOException {
        if (this.closed) {
            return;
        }
        this.closed = true;
        this.jfd.close();
    }

    @Override
    public final boolean readBoolean() throws IOException {
        return this.readByte() != 0;
    }

    @Override
    public final byte readByte() throws IOException {
        int ch = this.read();
        if (ch < 0) {
            throw new EOFException();
        }
        return (byte)ch;
    }

    @Override
    public final int readUnsignedByte() throws IOException {
        return this.readByte() & 0xFF;
    }

    @Override
    public final short readShort() throws IOException {
        this.read(this.temp, 0, 2);
        return JTranscData.readInt16BE((byte[])this.temp);
    }

    @Override
    public final int readUnsignedShort() throws IOException {
        return this.readShort() & 0xFFFF;
    }

    @Override
    public final char readChar() throws IOException {
        return (char)this.readUnsignedShort();
    }

    @Override
    public final int readInt() throws IOException {
        this.read(this.temp, 0, 4);
        return JTranscData.readInt32BE((byte[])this.temp);
    }

    @Override
    public final long readLong() throws IOException {
        return ((long)this.readInt() << 32) + ((long)this.readInt() & 0xFFFFFFFFL);
    }

    @Override
    public final float readFloat() throws IOException {
        return Float.intBitsToFloat(this.readInt());
    }

    @Override
    public final double readDouble() throws IOException {
        return Double.longBitsToDouble(this.readLong());
    }

    @Override
    public final String readLine() throws IOException {
        StringBuffer input = new StringBuffer();
        int c = -1;
        boolean eol = false;
        block4: while (!eol) {
            c = this.read();
            switch (c) {
                case -1: 
                case 10: {
                    eol = true;
                    continue block4;
                }
                case 13: {
                    eol = true;
                    long cur = this.getFilePointer();
                    if (this.read() == 10) continue block4;
                    this.seek(cur);
                    continue block4;
                }
            }
            input.append((char)c);
        }
        if (c == -1 && input.length() == 0) {
            return null;
        }
        return input.toString();
    }

    @Override
    public final String readUTF() throws IOException {
        return DataInputStream.readUTF(this);
    }

    @Override
    public final void writeBoolean(boolean v) throws IOException {
        this.write(v ? 1 : 0);
    }

    @Override
    public final void writeByte(int v) throws IOException {
        this.write(v);
    }

    @Override
    public final void writeShort(int v) throws IOException {
        this.write(JTranscData.getInt16BE((byte[])this.temp, (short)((short)v)), 0, 2);
    }

    @Override
    public final void writeChar(int v) throws IOException {
        this.writeShort(v);
    }

    @Override
    public final void writeInt(int v) throws IOException {
        this.write(JTranscData.getInt32BE((byte[])this.temp, (int)((short)v)), 0, 4);
    }

    @Override
    public final void writeLong(long v) throws IOException {
        this.write(JTranscData.getInt64BE((byte[])this.temp, (long)v), 0, 8);
    }

    @Override
    public final void writeFloat(float v) throws IOException {
        this.writeInt(Float.floatToIntBits(v));
    }

    @Override
    public final void writeDouble(double v) throws IOException {
        this.writeLong(Double.doubleToLongBits(v));
    }

    @Override
    public final void writeBytes(String s) throws IOException {
        this.write(s.getBytes());
    }

    @Override
    public final void writeChars(String s) throws IOException {
        this.write(s.getBytes("UTF-16"));
    }

    @Override
    public final void writeUTF(String str) throws IOException {
        DataOutputStream.writeUTF(str, this);
    }
}

