/*
 * Decompiled with CFR 0.152.
 */
package java.nio;

import java.nio.Buffer;
import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import java.nio.ByteOrder;
import java.nio.HeapLongBuffer;
import java.nio.ReadOnlyBufferException;

public abstract class LongBuffer
extends Buffer
implements Comparable<LongBuffer> {
    final long[] hb;
    final int offset;
    boolean isReadOnly;

    LongBuffer(int mark, int pos, int lim, int cap, long[] hb, int offset) {
        super(mark, pos, lim, cap);
        this.hb = hb;
        this.offset = offset;
    }

    LongBuffer(int mark, int pos, int lim, int cap) {
        this(mark, pos, lim, cap, null, 0);
    }

    public static LongBuffer allocate(int capacity) {
        if (capacity < 0) {
            throw new IllegalArgumentException();
        }
        return new HeapLongBuffer(capacity, capacity);
    }

    public static LongBuffer wrap(long[] array, int offset, int length) {
        try {
            return new HeapLongBuffer(array, offset, length);
        }
        catch (IllegalArgumentException x) {
            throw new IndexOutOfBoundsException();
        }
    }

    public static LongBuffer wrap(long[] array) {
        return LongBuffer.wrap(array, 0, array.length);
    }

    public abstract LongBuffer slice();

    public abstract LongBuffer duplicate();

    public abstract LongBuffer asReadOnlyBuffer();

    public abstract long get();

    public abstract LongBuffer put(long var1);

    public abstract long get(int var1);

    public abstract LongBuffer put(int var1, long var2);

    public LongBuffer get(long[] dst, int offset, int length) {
        LongBuffer.checkBounds(offset, length, dst.length);
        if (length > this.remaining()) {
            throw new BufferUnderflowException();
        }
        int end = offset + length;
        for (int i = offset; i < end; ++i) {
            dst[i] = this.get();
        }
        return this;
    }

    public LongBuffer get(long[] dst) {
        return this.get(dst, 0, dst.length);
    }

    public LongBuffer put(LongBuffer src) {
        if (src == this) {
            throw new IllegalArgumentException();
        }
        if (this.isReadOnly()) {
            throw new ReadOnlyBufferException();
        }
        int n = src.remaining();
        if (n > this.remaining()) {
            throw new BufferOverflowException();
        }
        for (int i = 0; i < n; ++i) {
            this.put(src.get());
        }
        return this;
    }

    public LongBuffer put(long[] src, int offset, int length) {
        LongBuffer.checkBounds(offset, length, src.length);
        if (length > this.remaining()) {
            throw new BufferOverflowException();
        }
        int end = offset + length;
        for (int i = offset; i < end; ++i) {
            this.put(src[i]);
        }
        return this;
    }

    public final LongBuffer put(long[] src) {
        return this.put(src, 0, src.length);
    }

    @Override
    public final boolean hasArray() {
        return this.hb != null && !this.isReadOnly;
    }

    public final long[] array() {
        this.check();
        return this.hb;
    }

    @Override
    public final int arrayOffset() {
        this.check();
        return this.offset;
    }

    private void check() {
        if (this.hb == null) {
            throw new UnsupportedOperationException();
        }
        if (this.isReadOnly) {
            throw new ReadOnlyBufferException();
        }
    }

    public abstract LongBuffer compact();

    @Override
    public abstract boolean isDirect();

    public String toString() {
        return this.getClass().getName() + "[pos=" + this.position() + " lim=" + this.limit() + " cap=" + this.capacity() + "]";
    }

    public int hashCode() {
        int h = 1;
        int p = this.position();
        for (int i = this.limit() - 1; i >= p; --i) {
            h = 31 * h + (int)this.get(i);
        }
        return h;
    }

    public boolean equals(Object ob) {
        if (this == ob) {
            return true;
        }
        if (!(ob instanceof LongBuffer)) {
            return false;
        }
        LongBuffer that = (LongBuffer)ob;
        if (this.remaining() != that.remaining()) {
            return false;
        }
        int p = this.position();
        int i = this.limit() - 1;
        int j = that.limit() - 1;
        while (i >= p) {
            if (this.get(i) != that.get(j)) {
                return false;
            }
            --i;
            --j;
        }
        return true;
    }

    @Override
    public int compareTo(LongBuffer that) {
        int n = this.position() + Math.min(this.remaining(), that.remaining());
        int i = this.position();
        int j = that.position();
        while (i < n) {
            int cmp = Long.compare(this.get(i), that.get(j));
            if (cmp != 0) {
                return cmp;
            }
            ++i;
            ++j;
        }
        return this.remaining() - that.remaining();
    }

    public abstract ByteOrder order();
}

