/*
 * Decompiled with CFR 0.152.
 */
package java.nio.charset;

import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.UnsupportedCharsetException;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import java.util.SortedMap;
import jtransc.FastStringMap;
import jtransc.JTranscGenericCharset;

public abstract class Charset
implements Comparable<Charset> {
    private static FastStringMap<Charset> charsets = null;
    private static Charset _default;
    private String canonicalName;
    private Set<String> aliases;

    public static native boolean isSupported(String var0);

    public static native SortedMap<String, Charset> availableCharsets();

    public static Charset forName(String charsetName) {
        charsetName = charsetName.toUpperCase();
        if (charsets == null) {
            charsets = new FastStringMap();
            charsets.set("UTF-8", (Object)new JTranscGenericCharset("UTF-8", new String[0]));
            charsets.set("ISO-8859-1", (Object)new JTranscGenericCharset("ISO-8859-1", new String[0]));
            charsets.set("UTF-16", (Object)new JTranscGenericCharset("UTF-16", new String[0]));
            charsets.set("UTF-16LE", (Object)new JTranscGenericCharset("UTF-16LE", new String[0]));
            charsets.set("UTF-16BE", (Object)new JTranscGenericCharset("UTF-16BE", new String[0]));
            charsets.set("US-ASCII", (Object)new JTranscGenericCharset("US-ASCII", new String[0]));
        }
        if (charsets.has(charsetName)) {
            return (Charset)charsets.get(charsetName);
        }
        throw new UnsupportedCharsetException(charsetName);
    }

    public static Charset defaultCharset() {
        if (_default == null) {
            _default = Charset.forName("UTF-8");
        }
        return _default;
    }

    protected Charset(String canonicalName, String[] aliases) {
        this.canonicalName = canonicalName;
        this.aliases = new HashSet<String>();
        for (int n = 0; n < aliases.length; ++n) {
            this.aliases.add(aliases[n]);
        }
    }

    public final String name() {
        return this.canonicalName;
    }

    public final Set<String> aliases() {
        return this.aliases;
    }

    public String displayName() {
        return this.canonicalName;
    }

    public final boolean isRegistered() {
        return true;
    }

    public String displayName(Locale locale) {
        return this.canonicalName;
    }

    public abstract boolean contains(Charset var1);

    public abstract CharsetDecoder newDecoder();

    public abstract CharsetEncoder newEncoder();

    public boolean canEncode() {
        return true;
    }

    public final CharBuffer decode(ByteBuffer bb) {
        try {
            byte[] data = new byte[bb.limit()];
            for (int n = 0; n < data.length; ++n) {
                data[n] = bb.get(n);
            }
            return CharBuffer.wrap(new String(data, this.canonicalName));
        }
        catch (UnsupportedEncodingException e) {
            throw new Error(e);
        }
    }

    public final ByteBuffer encode(CharBuffer cb) {
        try {
            char[] data = new char[cb.limit()];
            for (int n = 0; n < data.length; ++n) {
                data[n] = cb.get(n);
            }
            return ByteBuffer.wrap(new String(data).getBytes(this.canonicalName));
        }
        catch (UnsupportedEncodingException e) {
            throw new Error(e);
        }
    }

    public final ByteBuffer encode(String str) {
        return this.encode(CharBuffer.wrap(str));
    }

    public final int hashCode() {
        return this.displayName().hashCode();
    }

    @Override
    public final native int compareTo(Charset var1);

    public final native boolean equals(Object var1);

    public final String toString() {
        return this.displayName();
    }
}

