/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.charset.IllegalCharsetNameException;
import java.nio.charset.UnsupportedCharsetException;
import java.util.Locale;
import java.util.Objects;
import jtransc.internal.IntJTranscStrings;

public class PrintWriter
extends Writer {
    public static char[] temp = new char[8];
    protected Writer out;
    private final boolean autoFlush;
    private boolean trouble = false;
    private PrintStream psOut = null;
    private final String lineSeparator;

    private static Charset toCharset(String csn) throws UnsupportedEncodingException {
        Objects.requireNonNull(csn, "charsetName");
        try {
            return Charset.forName(csn);
        }
        catch (IllegalCharsetNameException unused) {
            throw new UnsupportedEncodingException(csn);
        }
        catch (UnsupportedCharsetException unused) {
            throw new UnsupportedEncodingException(csn);
        }
    }

    public PrintWriter(Writer out) {
        this(out, false);
    }

    public PrintWriter(Writer out, boolean autoFlush) {
        super(out);
        this.out = out;
        this.autoFlush = autoFlush;
        this.lineSeparator = System.getProperty("line.separator");
    }

    public PrintWriter(OutputStream out) {
        this(out, false);
    }

    public PrintWriter(OutputStream out, boolean autoFlush) {
        this(new BufferedWriter(new OutputStreamWriter(out)), autoFlush);
        if (out instanceof PrintStream) {
            this.psOut = (PrintStream)out;
        }
    }

    public PrintWriter(String fileName) throws FileNotFoundException {
        this(new BufferedWriter(new OutputStreamWriter(new FileOutputStream(fileName))), false);
    }

    private PrintWriter(Charset charset, File file) throws FileNotFoundException {
        this(new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), charset)), false);
    }

    public PrintWriter(String fileName, String csn) throws FileNotFoundException, UnsupportedEncodingException {
        this(PrintWriter.toCharset(csn), new File(fileName));
    }

    public PrintWriter(File file) throws FileNotFoundException {
        this(new BufferedWriter(new OutputStreamWriter(new FileOutputStream(file))), false);
    }

    public PrintWriter(File file, String csn) throws FileNotFoundException, UnsupportedEncodingException {
        this(PrintWriter.toCharset(csn), file);
    }

    private void ensureOpen() throws IOException {
        if (this.out == null) {
            throw new IOException("Stream closed");
        }
    }

    @Override
    public void flush() {
        try {
            this.ensureOpen();
            this.out.flush();
        }
        catch (IOException x) {
            this.trouble = true;
        }
    }

    @Override
    public void close() {
        try {
            if (this.out == null) {
                return;
            }
            this.out.close();
            this.out = null;
        }
        catch (IOException x) {
            this.trouble = true;
        }
    }

    public boolean checkError() {
        if (this.out != null) {
            this.flush();
        }
        if (this.out instanceof PrintWriter) {
            PrintWriter pw = (PrintWriter)this.out;
            return pw.checkError();
        }
        if (this.psOut != null) {
            return this.psOut.checkError();
        }
        return this.trouble;
    }

    protected void setError() {
        this.trouble = true;
    }

    protected void clearError() {
        this.trouble = false;
    }

    @Override
    public void write(int value) {
        this.write(new char[]{(char)value}, 0, 1);
    }

    @Override
    public void write(char[] value, int offset, int length) {
        try {
            this.ensureOpen();
            this.out.write(value, offset, length);
        }
        catch (IOException x) {
            this.trouble = true;
        }
    }

    @Override
    public void write(char[] value) {
        this.write(value, 0, value.length);
    }

    @Override
    public void write(String s, int off, int len) {
        this.write(IntJTranscStrings.getChars(s, off, len));
    }

    @Override
    public void write(String s) {
        this.write(s, 0, s.length());
    }

    private void _printNewLine() {
        this.write(this.lineSeparator);
        if (this.autoFlush) {
            this.flush();
        }
    }

    public void print(boolean b) {
        this.write(String.valueOf(b));
    }

    public void print(char value) {
        this.write(value);
    }

    public void print(int value) {
        this.write(String.valueOf(value));
    }

    public void print(long value) {
        this.write(String.valueOf(value));
    }

    public void print(float value) {
        this.write(String.valueOf(value));
    }

    public void print(double value) {
        this.write(String.valueOf(value));
    }

    public void print(char[] value) {
        this.write(value);
    }

    public void print(String value) {
        this.write(value != null ? value : "null");
    }

    public void print(Object obj) {
        this.write(String.valueOf(obj));
    }

    public void println() {
        this._println("");
    }

    public void println(boolean x) {
        this._println(String.valueOf(x));
    }

    public void println(char x) {
        this._println(String.valueOf(x));
    }

    public void println(int x) {
        this._println(String.valueOf(x));
    }

    public void println(long x) {
        this._println(String.valueOf(x));
    }

    public void println(float x) {
        this._println(String.valueOf(x));
    }

    public void println(double x) {
        this._println(String.valueOf(x));
    }

    public void println(char[] x) {
        this._println(String.valueOf(x));
    }

    public void println(String x) {
        this._println(x);
    }

    public void println(Object x) {
        this._println(String.valueOf(x));
    }

    private void _println(String x) {
        this.print(x);
        this._printNewLine();
    }

    public PrintWriter printf(String format, Object ... args) {
        return this.format(format, args);
    }

    public PrintWriter printf(Locale l, String format, Object ... args) {
        return this.format(l, format, args);
    }

    public PrintWriter format(String format, Object ... args) {
        this.write(String.format(format, args));
        return this;
    }

    public PrintWriter format(Locale l, String format, Object ... args) {
        this.write(String.format(l, format, args));
        return this;
    }

    @Override
    public PrintWriter append(CharSequence csq) {
        this.write(csq != null ? csq.toString() : "null");
        return this;
    }

    @Override
    public PrintWriter append(CharSequence csq, int start, int end) {
        CharSequence cs = csq == null ? "null" : csq;
        this.write(cs.subSequence(start, end).toString());
        return this;
    }

    @Override
    public PrintWriter append(char c) {
        this.write(c);
        return this;
    }
}

