/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import java.io.File;
import java.io.FileDescriptor;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;

public class FileInputStream
extends InputStream {
    private final FileDescriptor fd;
    private final String path;
    private volatile boolean closed = false;

    public FileInputStream(String name) throws FileNotFoundException {
        this(name != null ? new File(name) : null);
    }

    public FileInputStream(File file) throws FileNotFoundException {
        String name;
        String string = name = file != null ? file.getPath() : null;
        if (name == null) {
            throw new NullPointerException();
        }
        if (file.isInvalid()) {
            throw new FileNotFoundException("Invalid file path");
        }
        this.fd = new FileDescriptor();
        this.path = name;
        this.open(name);
    }

    public FileInputStream(FileDescriptor fdObj) {
        if (fdObj == null) {
            throw new NullPointerException();
        }
        this.fd = fdObj;
        this.path = null;
    }

    private native void open(String var1) throws FileNotFoundException;

    @Override
    public int read() throws IOException {
        return this.read0();
    }

    private native int read0() throws IOException;

    private native int readBytes(byte[] var1, int var2, int var3) throws IOException;

    @Override
    public int read(byte[] b) throws IOException {
        return this.readBytes(b, 0, b.length);
    }

    @Override
    public int read(byte[] data, int offset, int length) throws IOException {
        return this.readBytes(data, offset, length);
    }

    @Override
    public native long skip(long var1) throws IOException;

    @Override
    public native int available() throws IOException;

    @Override
    public void close() throws IOException {
        if (this.closed) {
            return;
        }
        this.closed = true;
    }

    public final FileDescriptor getFD() throws IOException {
        if (this.fd != null) {
            return this.fd;
        }
        throw new IOException();
    }

    private native void close0() throws IOException;

    protected void finalize() throws IOException {
        if (this.fd != null && this.fd != FileDescriptor.in) {
            this.close();
        }
    }
}

