/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import jtransc.annotation.JTranscKeep;

public final class Byte
extends Number
implements Comparable<Byte> {
    public static final byte MIN_VALUE = -128;
    public static final byte MAX_VALUE = 127;
    public static final Class<Byte> TYPE = Class.getPrimitiveClass("byte");
    static final Byte[] cache = new Byte[256];
    private final byte value;
    public static final int SIZE = 8;
    public static final int BYTES = 1;

    public static String toString(byte value) {
        return Integer.toString(value, 10);
    }

    @JTranscKeep
    public static Byte valueOf(byte value) {
        int index = value + 128;
        if (cache[index] == null) {
            Byte.cache[index] = new Byte(value);
        }
        return cache[index];
    }

    public static byte parseByte(String value, int radix) throws NumberFormatException {
        return (byte)Byte.checkDecode(value, Integer.parseInt(value, radix));
    }

    public static byte parseByte(String value) throws NumberFormatException {
        return Byte.parseByte(value, 10);
    }

    public static Byte valueOf(String value, int radix) throws NumberFormatException {
        return Byte.parseByte(value, radix);
    }

    public static Byte valueOf(String value) throws NumberFormatException {
        return Byte.parseByte(value);
    }

    private static int checkDecode(String value, int decoded) throws NumberFormatException {
        if (decoded < -128 || decoded > 127) {
            throw new NumberFormatException("Value " + decoded + " out of range from input " + value);
        }
        return decoded;
    }

    public static Byte decode(String value) throws NumberFormatException {
        return (byte)Byte.checkDecode(value, Integer.decode(value));
    }

    public Byte(byte value) {
        this.value = value;
    }

    public Byte(String value) throws NumberFormatException {
        this.value = Byte.parseByte(value, 10);
    }

    @Override
    public byte byteValue() {
        return this.value;
    }

    @Override
    public short shortValue() {
        return this.value;
    }

    @Override
    public int intValue() {
        return this.value;
    }

    @Override
    public long longValue() {
        return this.value;
    }

    @Override
    public float floatValue() {
        return this.value;
    }

    @Override
    public double doubleValue() {
        return this.value;
    }

    public String toString() {
        return Integer.toString(this.value);
    }

    public int hashCode() {
        return Byte.hashCode(this.value);
    }

    public static int hashCode(byte value) {
        return value;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Byte)) {
            return false;
        }
        return this.value == (Byte)obj;
    }

    @Override
    public int compareTo(Byte that) {
        return Byte.compare(this.value, that.value);
    }

    public static int compare(byte l, byte r) {
        return l - r;
    }

    public static int toUnsignedInt(byte value) {
        return value & 0xFF;
    }

    public static long toUnsignedLong(byte value) {
        return (long)value & 0xFFL;
    }
}

