/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import java.io.InputStream;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Objects;
import jtransc.FastStringMap;
import jtransc.annotation.JTranscKeep;

public final class Class<T>
implements Serializable,
Type,
GenericDeclaration,
AnnotatedElement {
    private static final int ANNOTATION = 8192;
    private static final int ENUM = 16384;
    private static final int SYNTHETIC = 4096;
    @JTranscKeep
    private String name;
    @JTranscKeep
    private boolean primitive = false;
    private static FastStringMap<Class<?>> _classCache = new FastStringMap();
    private volatile transient T[] enumConstants = null;
    private FastStringMap<Field> _fieldsByName;
    private FastStringMap<Field> _declaredFieldsByName;

    public native Field[] getDeclaredFields() throws SecurityException;

    public native Method[] getDeclaredMethods() throws SecurityException;

    public native Constructor<?>[] getDeclaredConstructors() throws SecurityException;

    public native Class<? super T> getSuperclass();

    public native Class<?>[] getInterfaces();

    @Override
    public native Annotation[] getDeclaredAnnotations();

    public native int getModifiers();

    public native T newInstance() throws InstantiationException, IllegalAccessException;

    public native Class<?>[] getDeclaredClasses() throws SecurityException;

    public native Method getEnclosingMethod();

    public native Constructor<?> getEnclosingConstructor() throws SecurityException;

    public native URL getResource(String var1);

    public native boolean isInstance(Object var1);

    public native InputStream getResourceAsStream(String var1);

    public ClassLoader getClassLoader() {
        return _ClassInternalUtils.getSystemClassLoader();
    }

    public native TypeVariable<Class<T>>[] getTypeParameters();

    public native Type getGenericSuperclass();

    public native Package getPackage();

    public native Type[] getGenericInterfaces();

    public native Class<?> getComponentType();

    public native Object[] getSigners();

    public native Class<?> getDeclaringClass() throws SecurityException;

    public native Class<?> getEnclosingClass() throws SecurityException;

    public native Class<?>[] getClasses();

    @JTranscKeep
    private Class() {
    }

    @JTranscKeep
    Class(String name) throws ClassNotFoundException {
        this.name = name;
        this.primitive = false;
        if (!this._check()) {
            throw new ClassNotFoundException("Can't find class " + name);
        }
    }

    @JTranscKeep
    Class(String name, boolean primitive) {
        this.name = name;
        this.primitive = primitive;
    }

    @JTranscKeep
    private native boolean _check();

    @JTranscKeep
    public String getName() {
        return this.name;
    }

    @JTranscKeep
    static Class<?> getPrimitiveClass(String name) {
        return new Class(name, true);
    }

    public String toString() {
        return (this.isInterface() ? "interface " : (this.isPrimitive() ? "" : "class ")) + this.getName();
    }

    public native String toGenericString();

    static Class<?> forName0(String className) {
        try {
            return Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    @JTranscKeep
    public static Class<?> forName(String className) throws ClassNotFoundException {
        if (className.length() == 1) {
            switch (className.charAt(0)) {
                case 'V': {
                    return Void.TYPE;
                }
                case 'Z': {
                    return Boolean.TYPE;
                }
                case 'B': {
                    return Byte.TYPE;
                }
                case 'C': {
                    return Character.TYPE;
                }
                case 'S': {
                    return Short.TYPE;
                }
                case 'D': {
                    return Double.TYPE;
                }
                case 'F': {
                    return Float.TYPE;
                }
                case 'I': {
                    return Integer.TYPE;
                }
                case 'J': {
                    return Long.TYPE;
                }
            }
        }
        if (className.startsWith("L") && className.endsWith(";")) {
            return Class.forName(className.substring(1, className.length() - 1).replace('/', '.'));
        }
        if (!_classCache.has(className)) {
            _classCache.set(className, new Class(className));
        }
        return (Class)_classCache.get(className);
    }

    public static Class<?> forName(String name, boolean initialize, ClassLoader loader) throws ClassNotFoundException {
        return Class.forName(name);
    }

    public boolean isAssignableFrom(Class<?> cls) {
        try {
            return this.isInstance(cls.newInstance());
        }
        catch (Exception e) {
            return false;
        }
    }

    public boolean isInterface() {
        return Modifier.isInterface(this.getModifiers());
    }

    public boolean isArray() {
        return this.name.startsWith("[");
    }

    public boolean isPrimitive() {
        return this.primitive;
    }

    public boolean isAnnotation() {
        return (this.getModifiers() & 0x2000) != 0;
    }

    public boolean isSynthetic() {
        return (this.getModifiers() & 0x1000) != 0;
    }

    public boolean isEnum() {
        return (this.getModifiers() & 0x4000) != 0;
    }

    public String getSimpleName() {
        String out = this.name.substring(this.name.lastIndexOf(46) + 1);
        if (this.isArray()) {
            out = out + "[]";
        }
        return out;
    }

    public native String getTypeName();

    public String getCanonicalName() {
        return this.name.replace('.', '/');
    }

    public boolean isAnonymousClass() {
        return "".equals(this.getSimpleName());
    }

    public boolean isLocalClass() {
        return this.isLocalOrAnonymousClass() && !this.isAnonymousClass();
    }

    private boolean isLocalOrAnonymousClass() {
        return this.getEnclosingMethodInfo() != null;
    }

    public boolean isMemberClass() {
        return this.getSimpleBinaryName() != null && !this.isLocalOrAnonymousClass();
    }

    private native Object getEnclosingMethodInfo();

    private String getSimpleBinaryName() {
        Class<?> enclosingClass = this.getEnclosingClass();
        if (enclosingClass == null) {
            return null;
        }
        try {
            return this.getName().substring(enclosingClass.getName().length());
        }
        catch (IndexOutOfBoundsException ex) {
            throw new InternalError("Malformed class name", ex);
        }
    }

    public boolean desiredAssertionStatus() {
        return false;
    }

    public T[] getEnumConstants() {
        T[] values = this.getEnumConstantsShared();
        if (values == null) {
            System.out.println("Class " + this + " is not an enum (" + this.isEnum() + ")!");
            try {
                Method valuesMethod = this.getMethod("values", new Class[0]);
                System.out.println("values method:" + valuesMethod);
            }
            catch (NoSuchMethodException e) {
                throw new Error(e);
            }
        }
        return values != null ? (Object[])values.clone() : null;
    }

    T[] getEnumConstantsShared() {
        if (this.enumConstants == null) {
            if (!this.isEnum()) {
                return null;
            }
            try {
                Method valuesMethod = this.getMethod("values", new Class[0]);
                Object[] temporaryConstants = (Object[])valuesMethod.invoke(null, new Object[0]);
                this.enumConstants = temporaryConstants;
            }
            catch (Exception ex) {
                return null;
            }
        }
        return this.enumConstants;
    }

    public T cast(Object obj) {
        if (obj != null && !this.isInstance(obj)) {
            throw new ClassCastException(this.cannotCastMsg(obj));
        }
        return (T)obj;
    }

    private String cannotCastMsg(Object obj) {
        return "Cannot cast " + obj.getClass().getName() + " to " + this.getName();
    }

    public <U> Class<? extends U> asSubclass(Class<U> clazz) {
        if (!clazz.isAssignableFrom(this)) {
            throw new ClassCastException(this.toString());
        }
        return this;
    }

    public Field[] getFields() throws SecurityException {
        return this.getDeclaredFields();
    }

    public Field getField(String name) throws NoSuchFieldException, SecurityException {
        if (this._fieldsByName == null) {
            this._fieldsByName = new FastStringMap();
            for (Field f : this.getFields()) {
                this._fieldsByName.set(f.getName(), (Object)f);
            }
        }
        return (Field)this._fieldsByName.get(name);
    }

    public Field getDeclaredField(String name) throws NoSuchFieldException, SecurityException {
        if (this._declaredFieldsByName == null) {
            this._declaredFieldsByName = new FastStringMap();
            for (Field f : this.getDeclaredFields()) {
                this._declaredFieldsByName.set(f.getName(), (Object)f);
            }
        }
        return (Field)this._declaredFieldsByName.get(name);
    }

    public Method[] getMethods() throws SecurityException {
        return this.getDeclaredMethods();
    }

    @Override
    public Annotation[] getAnnotations() {
        return this.getDeclaredAnnotations();
    }

    public Constructor<?>[] getConstructors() throws SecurityException {
        return this.getDeclaredConstructors();
    }

    public Method getMethod(String name, Class<?> ... parameterTypes) throws NoSuchMethodException, SecurityException {
        return this.getDeclaredMethod(name, parameterTypes);
    }

    public Constructor<T> getConstructor(Class<?> ... parameterTypes) throws NoSuchMethodException, SecurityException {
        return this.getDeclaredConstructor(parameterTypes);
    }

    public Method getDeclaredMethod(String name, Class<?> ... parameterTypes) throws NoSuchMethodException, SecurityException {
        for (Method m : this.getDeclaredMethods()) {
            if (!Objects.equals(m.getName(), name) || !Arrays.equals(m.getParameterTypes(), parameterTypes)) continue;
            return m;
        }
        throw new NoSuchMethodException(name);
    }

    public Constructor<T> getDeclaredConstructor(Class<?> ... parameterTypes) throws NoSuchMethodException, SecurityException {
        for (Constructor<?> c : this.getDeclaredConstructors()) {
            if (!Arrays.equals(c.getParameterTypes(), parameterTypes)) continue;
            return c;
        }
        throw new NoSuchMethodException();
    }

    public boolean isAnnotationPresent(Class<? extends Annotation> annotationClass) {
        return this.getDeclaredAnnotation(annotationClass) != null;
    }

    public <A extends Annotation> A getAnnotation(Class<A> annotationClass) {
        for (Annotation a : this.getAnnotations()) {
            if (a.getClass() != annotationClass) continue;
            return (A)a;
        }
        return null;
    }

    public <A extends Annotation> A[] getAnnotationsByType(Class<A> annotationClass) {
        ArrayList<Annotation> out = new ArrayList<Annotation>();
        for (Annotation a : this.getAnnotations()) {
            if (a.getClass() != annotationClass) continue;
            out.add(a);
        }
        return out.toArray(new Annotation[0]);
    }

    public <A extends Annotation> A getDeclaredAnnotation(Class<A> annotationClass) {
        for (Annotation a : this.getDeclaredAnnotations()) {
            if (a.getClass() != annotationClass) continue;
            return (A)a;
        }
        return null;
    }

    public <A extends Annotation> A[] getDeclaredAnnotationsByType(Class<A> annotationClass) {
        ArrayList<Annotation> out = new ArrayList<Annotation>();
        for (Annotation a : this.getDeclaredAnnotations()) {
            if (a.getClass() != annotationClass) continue;
            out.add(a);
        }
        return out.toArray(new Annotation[0]);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Class aClass = (Class)o;
        if (this.isPrimitive() != aClass.isPrimitive()) {
            return false;
        }
        return this.name != null ? this.name.equals(aClass.name) : aClass.name == null;
    }

    public int hashCode() {
        return this.name.hashCode();
    }
}

