/*
 * Decompiled with CFR 0.152.
 */
package java.net;

import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLStreamHandler;

public final class URL
implements Serializable {
    private String protocol;
    private String host;
    private int port = -1;
    private String file;
    private transient String query;
    private String authority;
    private transient String path;
    private transient String userInfo;
    private String ref;
    transient InetAddress hostAddress;
    transient URLStreamHandler handler;
    private int hashCode = -1;

    public URL(String protocol, String host, int port, String file) throws MalformedURLException {
        this(protocol, host, port, file, null);
    }

    public URL(String protocol, String host, String file) throws MalformedURLException {
        this(protocol, host, -1, file);
    }

    public URL(String protocol, String host, int port, String file, URLStreamHandler handler) throws MalformedURLException {
        this.protocol = protocol = protocol.toLowerCase();
        if (host != null) {
            if (host.indexOf(58) >= 0 && !host.startsWith("[")) {
                host = "[" + host + "]";
            }
            this.host = host;
            if (port < -1) {
                throw new MalformedURLException("Invalid port number :" + port);
            }
            this.port = port;
            this.authority = port == -1 ? host : host + ":" + port;
        }
        Parts parts = new Parts(file);
        this.path = parts.getPath();
        this.query = parts.getQuery();
        this.file = this.query != null ? this.path + "?" + this.query : this.path;
        this.ref = parts.getRef();
        if (handler == null && (handler = URL.getURLStreamHandler(protocol)) == null) {
            throw new MalformedURLException("unknown protocol: " + protocol);
        }
        this.handler = handler;
    }

    public URL(String spec) throws MalformedURLException {
        this(null, spec);
    }

    public URL(URL context, String spec) throws MalformedURLException {
        this(context, spec, null);
    }

    public URL(URL context, String spec, URLStreamHandler handler) throws MalformedURLException {
        String original = spec;
        int start = 0;
        String newProtocol = null;
        boolean aRef = false;
        boolean isRelative = false;
        try {
            char c;
            int i;
            int limit;
            for (limit = spec.length(); limit > 0 && spec.charAt(limit - 1) <= ' '; --limit) {
            }
            while (start < limit && spec.charAt(start) <= ' ') {
                ++start;
            }
            if (spec.regionMatches(true, start, "url:", 0, 4)) {
                start += 4;
            }
            if (start < spec.length() && spec.charAt(start) == '#') {
                aRef = true;
            }
            for (i = start; !aRef && i < limit && (c = spec.charAt(i)) != '/'; ++i) {
                if (c != ':') continue;
                String s = spec.substring(start, i).toLowerCase();
                if (!this.isValidProtocol(s)) break;
                newProtocol = s;
                start = i + 1;
                break;
            }
            this.protocol = newProtocol;
            if (context != null && (newProtocol == null || newProtocol.equalsIgnoreCase(context.protocol))) {
                if (handler == null) {
                    handler = context.handler;
                }
                if (context.path != null && context.path.startsWith("/")) {
                    newProtocol = null;
                }
                if (newProtocol == null) {
                    this.protocol = context.protocol;
                    this.authority = context.authority;
                    this.userInfo = context.userInfo;
                    this.host = context.host;
                    this.port = context.port;
                    this.file = context.file;
                    this.path = context.path;
                    isRelative = true;
                }
            }
            if (this.protocol == null) {
                throw new MalformedURLException("no protocol: " + original);
            }
            if (handler == null && (handler = URL.getURLStreamHandler(this.protocol)) == null) {
                throw new MalformedURLException("unknown protocol: " + this.protocol);
            }
            this.handler = handler;
            i = spec.indexOf(35, start);
            if (i >= 0) {
                this.ref = spec.substring(i + 1, limit);
                limit = i;
            }
            if (isRelative && start == limit) {
                this.query = context.query;
                if (this.ref == null) {
                    this.ref = context.ref;
                }
            }
            handler.parseURL(this, spec, start, limit);
        }
        catch (MalformedURLException e) {
            throw e;
        }
        catch (Exception e) {
            MalformedURLException exception = new MalformedURLException(e.getMessage());
            exception.initCause(e);
            throw exception;
        }
    }

    private boolean isValidProtocol(String protocol) {
        int len = protocol.length();
        if (len < 1) {
            return false;
        }
        char c = protocol.charAt(0);
        if (!Character.isLetter(c)) {
            return false;
        }
        for (int i = 1; i < len; ++i) {
            c = protocol.charAt(i);
            if (Character.isLetterOrDigit(c) || c == '.' || c == '+' || c == '-') continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void set(String protocol, String host, int port, String file, String ref) {
        URL uRL = this;
        synchronized (uRL) {
            this.protocol = protocol;
            this.host = host;
            this.authority = port == -1 ? host : host + ":" + port;
            this.port = port;
            this.file = file;
            this.ref = ref;
            this.hashCode = -1;
            int q = file.lastIndexOf(63);
            if (q != -1) {
                this.query = file.substring(q + 1);
                this.path = file.substring(0, q);
            } else {
                this.path = file;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void set(String protocol, String host, int port, String authority, String userInfo, String path, String query, String ref) {
        URL uRL = this;
        synchronized (uRL) {
            this.protocol = protocol;
            this.host = host;
            this.port = port;
            this.file = query == null ? path : path + "?" + query;
            this.userInfo = userInfo;
            this.path = path;
            this.ref = ref;
            this.hashCode = -1;
            this.query = query;
            this.authority = authority;
        }
    }

    public String getQuery() {
        return this.query;
    }

    public String getPath() {
        return this.path;
    }

    public String getUserInfo() {
        return this.userInfo;
    }

    public String getAuthority() {
        return this.authority;
    }

    public int getPort() {
        return this.port;
    }

    public int getDefaultPort() {
        return this.handler.getDefaultPort();
    }

    public String getProtocol() {
        return this.protocol;
    }

    public String getHost() {
        return this.host;
    }

    public String getFile() {
        return this.file;
    }

    public String getRef() {
        return this.ref;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof URL)) {
            return false;
        }
        URL that = (URL)obj;
        return this.handler.equals(this, that);
    }

    public synchronized int hashCode() {
        if (this.hashCode != -1) {
            return this.hashCode;
        }
        return this.handler.hashCode(this);
    }

    public boolean sameFile(URL other) {
        return this.handler.sameFile(this, other);
    }

    public String toString() {
        return this.toExternalForm();
    }

    public String toExternalForm() {
        return this.handler.toExternalForm(this);
    }

    public URI toURI() throws URISyntaxException {
        return new URI(this.toString());
    }

    static native URLStreamHandler getURLStreamHandler(String var0);

    public final native InputStream openStream() throws IOException;

    class Parts {
        String path;
        String query;
        String ref;

        Parts(String file) {
            int ind = file.indexOf(35);
            this.ref = ind < 0 ? null : file.substring(ind + 1);
            file = ind < 0 ? file : file.substring(0, ind);
            int q = file.lastIndexOf(63);
            if (q != -1) {
                this.query = file.substring(q + 1);
                this.path = file.substring(0, q);
            } else {
                this.path = file;
            }
        }

        String getPath() {
            return this.path;
        }

        String getQuery() {
            return this.query;
        }

        String getRef() {
            return this.ref;
        }
    }
}

