/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Deque;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.NavigableMap;
import java.util.NavigableSet;
import java.util.Objects;
import java.util.Queue;
import java.util.Random;
import java.util.RandomAccess;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;

public class Collections {
    private static List<Object> empty = new ArrayList<Object>();
    public static final Set EMPTY_SET = new HashSet();
    public static final List EMPTY_LIST = new ArrayList();
    public static final Map EMPTY_MAP = new HashMap();

    private Collections() {
    }

    public static native <T extends Comparable<? super T>> void sort(List<T> var0);

    public static native <T> void sort(List<T> var0, Comparator<? super T> var1);

    public static native <T> int binarySearch(List<? extends Comparable<? super T>> var0, T var1);

    public static native <T> int binarySearch(List<? extends T> var0, T var1, Comparator<? super T> var2);

    public static void reverse(List<?> list) {
        int size = list.size();
        int i = 0;
        int mid = size >> 1;
        int j = size - 1;
        while (i < mid) {
            Collections.swap(list, i, j);
            ++i;
            --j;
        }
    }

    public static native void shuffle(List<?> var0);

    public static native void shuffle(List<?> var0, Random var1);

    public static void swap(List<?> list, int i, int j) {
        List<?> l = list;
        l.set(i, l.set(j, l.get(i)));
    }

    public static <T> void fill(List<? super T> list, T obj) {
        int length = list.size();
        for (int n = 0; n < length; ++n) {
            list.set(n, obj);
        }
    }

    public static native <T> void copy(List<? super T> var0, List<? extends T> var1);

    public static native <T> T min(Collection<? extends T> var0);

    public static native <T> T min(Collection<? extends T> var0, Comparator<? super T> var1);

    public static native <T> T max(Collection<? extends T> var0);

    public static native <T> T max(Collection<? extends T> var0, Comparator<? super T> var1);

    public static void rotate(List<?> list, int distance) {
        int length = list.size();
        for (int n = 0; n < length; ++n) {
            Collections.swap(list, n, (n + distance) % length);
        }
    }

    public static <T> boolean replaceAll(List<T> list, T oldVal, T newVal) {
        int length = list.size();
        int count = 0;
        for (int n = 0; n < length; ++n) {
            if (!Objects.equals(list.get(n), oldVal)) continue;
            list.set(n, newVal);
            ++count;
        }
        return count > 0;
    }

    public static native int indexOfSubList(List<?> var0, List<?> var1);

    public static native int lastIndexOfSubList(List<?> var0, List<?> var1);

    public static <T> Collection<T> unmodifiableCollection(Collection<? extends T> c) {
        return c;
    }

    public static <T> Set<T> unmodifiableSet(Set<? extends T> s) {
        return s;
    }

    public static <T> SortedSet<T> unmodifiableSortedSet(SortedSet<T> s) {
        return s;
    }

    public static <T> NavigableSet<T> unmodifiableNavigableSet(NavigableSet<T> s) {
        return s;
    }

    public static <T> List<T> unmodifiableList(List<? extends T> list) {
        return list;
    }

    public static <K, V> Map<K, V> unmodifiableMap(Map<? extends K, ? extends V> m) {
        return m;
    }

    public static <K, V> SortedMap<K, V> unmodifiableSortedMap(SortedMap<K, ? extends V> m) {
        return m;
    }

    public static <K, V> NavigableMap<K, V> unmodifiableNavigableMap(NavigableMap<K, ? extends V> m) {
        return m;
    }

    public static <T> Collection<T> synchronizedCollection(Collection<T> c) {
        return c;
    }

    public static <T> Set<T> synchronizedSet(Set<T> s) {
        return s;
    }

    public static <T> SortedSet<T> synchronizedSortedSet(SortedSet<T> s) {
        return s;
    }

    public static <T> NavigableSet<T> synchronizedNavigableSet(NavigableSet<T> s) {
        return s;
    }

    static <T> List<T> synchronizedList(List<T> list, Object mutex) {
        return list instanceof RandomAccess ? list : list;
    }

    public static <K, V> Map<K, V> synchronizedMap(Map<K, V> m) {
        return m;
    }

    public static <K, V> SortedMap<K, V> synchronizedSortedMap(SortedMap<K, V> m) {
        return m;
    }

    public static <K, V> NavigableMap<K, V> synchronizedNavigableMap(NavigableMap<K, V> m) {
        return m;
    }

    public static native <E> Collection<E> checkedCollection(Collection<E> var0, Class<E> var1);

    public static native <E> Queue<E> checkedQueue(Queue<E> var0, Class<E> var1);

    public static native <E> Set<E> checkedSet(Set<E> var0, Class<E> var1);

    public static native <E> SortedSet<E> checkedSortedSet(SortedSet<E> var0, Class<E> var1);

    public static native <E> NavigableSet<E> checkedNavigableSet(NavigableSet<E> var0, Class<E> var1);

    public static native <E> List<E> checkedList(List<E> var0, Class<E> var1);

    public static native <K, V> Map<K, V> checkedMap(Map<K, V> var0, Class<K> var1, Class<V> var2);

    public static native <K, V> SortedMap<K, V> checkedSortedMap(SortedMap<K, V> var0, Class<K> var1, Class<V> var2);

    public static native <K, V> NavigableMap<K, V> checkedNavigableMap(NavigableMap<K, V> var0, Class<K> var1, Class<V> var2);

    public static <T> Iterator<T> emptyIterator() {
        return empty.iterator();
    }

    public static <T> ListIterator<T> emptyListIterator() {
        return empty.listIterator();
    }

    public static native <T> Enumeration<T> emptyEnumeration();

    public static final native <T> Set<T> emptySet();

    public static native <E> SortedSet<E> emptySortedSet();

    public static native <E> NavigableSet<E> emptyNavigableSet();

    public static final native <T> List<T> emptyList();

    public static final native <K, V> Map<K, V> emptyMap();

    public static final native <K, V> SortedMap<K, V> emptySortedMap();

    public static final native <K, V> NavigableMap<K, V> emptyNavigableMap();

    public static native <T> Set<T> singleton(T var0);

    static native <E> Iterator<E> singletonIterator(E var0);

    public static <T> List<T> singletonList(T o) {
        return Collections.nCopies(1, o);
    }

    public static <K, V> Map<K, V> singletonMap(K key, V value) {
        HashMap<K, V> ts = new HashMap<K, V>(1);
        ts.put(key, value);
        return ts;
    }

    public static <T> List<T> nCopies(int count, T o) {
        ArrayList<T> ts = new ArrayList<T>(count);
        for (int n = 0; n < count; ++n) {
            ts.add(o);
        }
        return ts;
    }

    public static native <T> Comparator<T> reverseOrder();

    public static native <T> Comparator<T> reverseOrder(Comparator<T> var0);

    public static native <T> Enumeration<T> enumeration(Collection<T> var0);

    public static native <T> ArrayList<T> list(Enumeration<T> var0);

    static native boolean eq(Object var0, Object var1);

    public static native int frequency(Collection<?> var0, Object var1);

    public static native boolean disjoint(Collection<?> var0, Collection<?> var1);

    public static <T> boolean addAll(Collection<? super T> c, T ... elements) {
        boolean out = false;
        for (T e : elements) {
            out |= c.add(e);
        }
        return out;
    }

    public static native <E> Set<E> newSetFromMap(Map<E, Boolean> var0);

    public static native <T> Queue<T> asLifoQueue(Deque<T> var0);
}

