/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import java.io.Serializable;

public final class Boolean
implements Serializable,
Comparable<Boolean> {
    public static final Boolean TRUE = new Boolean(true);
    public static final Boolean FALSE = new Boolean(false);
    public static final Class<Boolean> TYPE = Class.getPrimitiveClass("boolean");
    private boolean value;

    public Boolean(boolean value) {
        this.value = value;
    }

    public Boolean(String value) {
        this.value = Boolean.parseBoolean(value);
    }

    public static boolean parseBoolean(String value) {
        return value != null ? value.compareToIgnoreCase("true") == 0 : false;
    }

    public boolean booleanValue() {
        return this.value;
    }

    public static Boolean valueOf(boolean value) {
        return value ? TRUE : FALSE;
    }

    public static Boolean valueOf(String value) {
        return Boolean.parseBoolean(value);
    }

    public static String toString(boolean value) {
        return value ? "true" : "false";
    }

    public String toString() {
        return Boolean.toString(this.value);
    }

    public int hashCode() {
        return Boolean.hashCode(this.value);
    }

    public static int hashCode(boolean value) {
        return value ? 1 : 0;
    }

    public boolean equals(Object that) {
        if (this == that) {
            return true;
        }
        if (that == null) {
            return false;
        }
        if (this.getClass() != that.getClass()) {
            return false;
        }
        return this.value == ((Boolean)that).value;
    }

    public static boolean getBoolean(String name) {
        return Boolean.parseBoolean(System.getProperty(name));
    }

    @Override
    public int compareTo(Boolean that) {
        return that != null ? Boolean.compare(this.value, that.value) : Boolean.compare(this.value, false);
    }

    public static int compare(boolean l, boolean r) {
        return l == r ? 0 : (!l ? -1 : 1);
    }

    public static boolean logicalAnd(boolean l, boolean r) {
        return l & r;
    }

    public static boolean logicalOr(boolean l, boolean r) {
        return l | r;
    }

    public static boolean logicalXor(boolean l, boolean r) {
        return l ^ r;
    }
}

