/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import jtransc.annotation.JTranscKeep;
import jtransc.annotation.haxe.HaxeMethodBody;

public final class Float
extends Number
implements Comparable<Float> {
    public static final float POSITIVE_INFINITY = 1.0f / 0.0f;
    public static final float NEGATIVE_INFINITY = -1.0f / 0.0f;
    public static final float NaN = 0.0f / 0.0f;
    public static final float MAX_VALUE = 3.4028235E38f;
    public static final float MIN_NORMAL = 1.1754944E-38f;
    public static final float MIN_VALUE = 1.4E-45f;
    public static final int MAX_EXPONENT = 127;
    public static final int MIN_EXPONENT = -126;
    public static final int SIZE = 32;
    public static final int BYTES = 4;
    public static final Class<Float> TYPE = Class.getPrimitiveClass("float");
    private final float value;

    @HaxeMethodBody(value="return HaxeNatives.str('' + p0);")
    public static native String toString(float var0);

    public static native String toHexString(float var0);

    public static native Float valueOf(String var0) throws NumberFormatException;

    @JTranscKeep
    public static Float valueOf(float value) {
        return new Float(value);
    }

    public static native float parseFloat(String var0) throws NumberFormatException;

    @HaxeMethodBody(value="return Math.isNaN(p0);")
    public static native boolean isNaN(float var0);

    @HaxeMethodBody(value="return Math.isInfinite(p0);")
    public static native boolean isInfinite(float var0);

    @HaxeMethodBody(value="return Math.isFinite(p0);")
    public static native boolean isFinite(float var0);

    public Float(float value) {
        this.value = value;
    }

    public Float(double value) {
        this.value = (float)value;
    }

    public Float(String s) throws NumberFormatException {
        this.value = Float.parseFloat(s);
    }

    public native boolean isNaN();

    public native boolean isInfinite();

    public String toString() {
        return Float.toString(this.value);
    }

    @Override
    public native byte byteValue();

    @Override
    public native short shortValue();

    @Override
    public int intValue() {
        return (int)this.value;
    }

    @Override
    public long longValue() {
        return (long)this.value;
    }

    @Override
    public float floatValue() {
        return this.value;
    }

    @Override
    public double doubleValue() {
        return this.value;
    }

    public int hashCode() {
        return Float.hashCode(this.value);
    }

    public static int hashCode(float value) {
        return Float.floatToIntBits(value);
    }

    public boolean equals(Object obj) {
        return obj instanceof Float && Float.floatToIntBits(((Float)obj).value) == Float.floatToIntBits(this.value);
    }

    @HaxeMethodBody(value="return HaxeNatives.floatToIntBits(p0);")
    public static native int floatToIntBits(float var0);

    public static native int floatToRawIntBits(float var0);

    @HaxeMethodBody(value="return HaxeNatives.intBitsToFloat(p0);")
    public static native float intBitsToFloat(int var0);

    @Override
    public native int compareTo(Float var1);

    public static native int compare(float var0, float var1);

    public static native float sum(float var0, float var1);

    public static native float max(float var0, float var1);

    public static native float min(float var0, float var1);
}

