/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import jtransc.annotation.JTranscKeep;
import jtransc.annotation.haxe.HaxeMethodBody;

public final class Integer
extends Number
implements Comparable<Integer> {
    public static final int MIN_VALUE = -2147483648;
    public static final int MAX_VALUE = 0x7FFFFFFF;
    public static final Class<Integer> TYPE = Class.getPrimitiveClass("int");
    private int value;
    private static Integer[] values;
    private static final int MIN = -128;
    private static final int MAX = 128;
    private static final int LENGTH = 256;
    public static final int SIZE = 32;
    public static final int BYTES = 4;

    public Integer(int value) {
        this.value = value;
    }

    public Integer(String s) {
        this.value = Integer.parseInt(s, 10);
    }

    @HaxeMethodBody(value="return HaxeNatives.str(HaxeNatives.intToString(p0, p1));")
    public static native String toString(int var0, int var1);

    public static native String toUnsignedString(int var0, int var1);

    public static String toHexString(int i) {
        return Integer.toString(i, 16);
    }

    public static String toOctalString(int i) {
        return Integer.toString(i, 8);
    }

    public static String toBinaryString(int i) {
        return Integer.toString(i, 2);
    }

    public static String toString(int i) {
        return Integer.toString(i, 10);
    }

    public static String toUnsignedString(int i) {
        return Integer.toUnsignedString(i, 10);
    }

    @HaxeMethodBody(value="return HaxeNatives.parseInt(p0._str, p1);")
    public static native int parseInt(String var0, int var1);

    public static int parseInt(String s) {
        return Integer.parseInt(s, 10);
    }

    public static native int parseUnsignedInt(String var0, int var1);

    public static int parseUnsignedInt(String s) {
        return Integer.parseUnsignedInt(s, 10);
    }

    public static Integer valueOf(String s, int radix) {
        return new Integer(Integer.parseInt(s, radix));
    }

    public static Integer valueOf(String s) {
        return Integer.valueOf(s, 10);
    }

    @JTranscKeep
    public static Integer valueOf(int i) {
        if (values == null) {
            values = new Integer[256];
            for (int n = -128; n < 128; ++n) {
                Integer.values[n - -128] = new Integer(n);
            }
        }
        if (i >= -128 && i < 128) {
            return values[i - -128];
        }
        return new Integer(i);
    }

    @Override
    public byte byteValue() {
        return (byte)this.value;
    }

    @Override
    public short shortValue() {
        return (short)this.value;
    }

    @Override
    public int intValue() {
        return this.value;
    }

    @Override
    public long longValue() {
        return this.value;
    }

    @Override
    public float floatValue() {
        return this.value;
    }

    @Override
    public double doubleValue() {
        return this.value;
    }

    public String toString() {
        return Integer.toString(this.value);
    }

    public int hashCode() {
        return this.value;
    }

    public static int hashCode(int value) {
        return value;
    }

    public boolean equals(Object obj) {
        if (obj instanceof Integer) {
            return ((Integer)obj).value == this.value;
        }
        return false;
    }

    public static Integer getInteger(String nm) {
        return Integer.getInteger(nm, null);
    }

    public static Integer getInteger(String nm, int val) {
        Integer result = Integer.getInteger(nm, null);
        return result == null ? new Integer(val) : result;
    }

    public static Integer getInteger(String nm, Integer val) {
        String out = System.getProperty(nm);
        if (out == null) {
            return val;
        }
        try {
            return Integer.decode(nm);
        }
        catch (NumberFormatException e) {
            return val;
        }
    }

    public static Integer decode(String nm) throws NumberFormatException {
        if (nm.length() == 0) {
            throw new NumberFormatException("Zero length string");
        }
        if (nm.startsWith("-")) {
            return -Integer.decode(nm.substring(1)).intValue();
        }
        if (nm.startsWith("+")) {
            return Integer.decode(nm.substring(1));
        }
        if (nm.startsWith("0x")) {
            return Integer.parseInt(nm.substring(2), 16);
        }
        if (nm.startsWith("0X")) {
            return Integer.parseInt(nm.substring(2), 16);
        }
        if (nm.startsWith("#")) {
            return Integer.parseInt(nm.substring(1), 16);
        }
        if (nm.startsWith("0")) {
            return Integer.parseInt(nm.substring(1), 8);
        }
        return Integer.parseInt(nm, 10);
    }

    @Override
    public int compareTo(Integer anotherInteger) {
        return Integer.compare(this.value, anotherInteger.value);
    }

    public static int compare(int l, int r) {
        return l < r ? -1 : (l > r ? 1 : 0);
    }

    public static int compareUnsigned(int l, int r) {
        return Integer.compare(l + Integer.MIN_VALUE, r + Integer.MIN_VALUE);
    }

    public static long toUnsignedLong(int value) {
        return (long)value & 0xFFFFFFFFL;
    }

    public static int divideUnsigned(int dividend, int divisor) {
        return (int)(Integer.toUnsignedLong(dividend) / Integer.toUnsignedLong(divisor));
    }

    public static int remainderUnsigned(int dividend, int divisor) {
        return (int)(Integer.toUnsignedLong(dividend) % Integer.toUnsignedLong(divisor));
    }

    public static int highestOneBit(int value) {
        value |= value >> 1;
        value |= value >> 2;
        value |= value >> 4;
        value |= value >> 8;
        value |= value >> 16;
        return value - (value >>> 1);
    }

    public static int lowestOneBit(int value) {
        return value & -value;
    }

    public static int numberOfLeadingZeros(int value) {
        if (value == 0) {
            return 32;
        }
        int n = 1;
        if (value >>> 16 == 0) {
            n += 16;
            value <<= 16;
        }
        if (value >>> 24 == 0) {
            n += 8;
            value <<= 8;
        }
        if (value >>> 28 == 0) {
            n += 4;
            value <<= 4;
        }
        if (value >>> 30 == 0) {
            n += 2;
            value <<= 2;
        }
        return n -= value >>> 31;
    }

    public static int numberOfTrailingZeros(int value) {
        if (value == 0) {
            return 32;
        }
        int n = 31;
        int y = value << 16;
        if (y != 0) {
            n -= 16;
            value = y;
        }
        if ((y = value << 8) != 0) {
            n -= 8;
            value = y;
        }
        if ((y = value << 4) != 0) {
            n -= 4;
            value = y;
        }
        if ((y = value << 2) != 0) {
            n -= 2;
            value = y;
        }
        return n - (value << 1 >>> 31);
    }

    public static int bitCount(int value) {
        value -= value >>> 1 & 0x55555555;
        value = (value & 0x33333333) + (value >>> 2 & 0x33333333);
        value = value + (value >>> 4) & 0xF0F0F0F;
        value += value >>> 8;
        value += value >>> 16;
        return value & 0x3F;
    }

    public static int rotateLeft(int value, int distance) {
        return value << distance | value >>> -distance;
    }

    public static int rotateRight(int value, int distance) {
        return value >>> distance | value << -distance;
    }

    public static int reverse(int value) {
        value = (value & 0x55555555) << 1 | value >>> 1 & 0x55555555;
        value = (value & 0x33333333) << 2 | value >>> 2 & 0x33333333;
        value = (value & 0xF0F0F0F) << 4 | value >>> 4 & 0xF0F0F0F;
        value = value << 24 | (value & 0xFF00) << 8 | value >>> 8 & 0xFF00 | value >>> 24;
        return value;
    }

    public static int signum(int value) {
        return value >> 31 | -value >>> 31;
    }

    public static int reverseBytes(int value) {
        return value >>> 24 | value >> 8 & 0xFF00 | value << 8 & 0xFF0000 | value << 24;
    }

    public static int sum(int l, int r) {
        return l + r;
    }

    public static int max(int l, int r) {
        return Math.max(l, r);
    }

    public static int min(int l, int r) {
        return Math.min(l, r);
    }
}

