/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import jtransc.annotation.JTranscKeep;
import jtransc.annotation.haxe.HaxeMethodBody;

public final class Long
extends Number
implements Comparable<Long> {
    public static final long MIN_VALUE = -9223372036854775808L;
    public static final long MAX_VALUE = 0x7FFFFFFFFFFFFFFFL;
    public static final Class<Long> TYPE = Class.getPrimitiveClass("long");
    private final long value;
    public static final int SIZE = 64;
    public static final int BYTES = 8;

    public static native String toString(long var0, int var2);

    public static native String toUnsignedString(long var0, int var2);

    public static native String toHexString(long var0);

    public static native String toOctalString(long var0);

    public static native String toBinaryString(long var0);

    @HaxeMethodBody(value="return HaxeNatives.str('' + p0);")
    public static native String toString(long var0);

    public static native String toUnsignedString(long var0);

    public static native long parseLong(String var0, int var1) throws NumberFormatException;

    public static native long parseLong(String var0) throws NumberFormatException;

    public static native long parseUnsignedLong(String var0, int var1) throws NumberFormatException;

    public static native long parseUnsignedLong(String var0) throws NumberFormatException;

    public static native Long valueOf(String var0, int var1) throws NumberFormatException;

    public static native Long valueOf(String var0) throws NumberFormatException;

    @JTranscKeep
    public static Long valueOf(long l) {
        return new Long(l);
    }

    public static native Long decode(String var0) throws NumberFormatException;

    public Long(long value) {
        this.value = value;
    }

    public Long(String s) throws NumberFormatException {
        this.value = Long.parseLong(s, 10);
    }

    @Override
    public byte byteValue() {
        return (byte)this.value;
    }

    @Override
    public short shortValue() {
        return (short)this.value;
    }

    @Override
    public int intValue() {
        return (int)this.value;
    }

    @Override
    public long longValue() {
        return this.value;
    }

    @Override
    public float floatValue() {
        return this.value;
    }

    @Override
    public double doubleValue() {
        return this.value;
    }

    public String toString() {
        return Long.toString(this.value);
    }

    public int hashCode() {
        return Long.hashCode(this.value);
    }

    public static int hashCode(long value) {
        return (int)(value ^ value >>> 32);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Long)) {
            return false;
        }
        return this.value == (Long)obj;
    }

    public static native Long getLong(String var0);

    public static native Long getLong(String var0, long var1);

    @Override
    public native int compareTo(Long var1);

    public static int compare(long x, long y) {
        return x < y ? -1 : (x == y ? 0 : 1);
    }

    public static int compareUnsigned(long x, long y) {
        return Long.compare(x + Long.MIN_VALUE, y + Long.MIN_VALUE);
    }

    public static native long divideUnsigned(long var0, long var2);

    public static native long remainderUnsigned(long var0, long var2);

    public static native long highestOneBit(long var0);

    public static native long lowestOneBit(long var0);

    public static native int numberOfLeadingZeros(long var0);

    public static int numberOfTrailingZeros(long value) {
        int x;
        if (value == 0L) {
            return 64;
        }
        int n = 63;
        int y = (int)value;
        if (y != 0) {
            n -= 32;
            x = y;
        } else {
            x = (int)(value >>> 32);
        }
        y = x << 16;
        if (y != 0) {
            n -= 16;
            x = y;
        }
        if ((y = x << 8) != 0) {
            n -= 8;
            x = y;
        }
        if ((y = x << 4) != 0) {
            n -= 4;
            x = y;
        }
        if ((y = x << 2) != 0) {
            n -= 2;
            x = y;
        }
        return n - (x << 1 >>> 31);
    }

    public static native int bitCount(long var0);

    public static native long rotateLeft(long var0, int var2);

    public static native long rotateRight(long var0, int var2);

    public static native long reverse(long var0);

    public static native int signum(long var0);

    public static native long reverseBytes(long var0);

    public static native long sum(long var0, long var2);

    public static native long max(long var0, long var2);

    public static native long min(long var0, long var2);
}

