/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import java.util.Random;

public final class StrictMath {
    public static final double E = Math.E;
    public static final double PI = Math.PI;
    private static Random randomNumberGenerator = null;

    private StrictMath() {
    }

    public static double sin(double a) {
        return Math.sin(a);
    }

    public static double cos(double a) {
        return Math.cos(a);
    }

    public static double tan(double a) {
        return Math.tan(a);
    }

    public static double asin(double a) {
        return Math.asin(a);
    }

    public static double acos(double a) {
        return Math.acos(a);
    }

    public static double atan(double a) {
        return Math.atan(a);
    }

    public static strictfp double toRadians(double angdeg) {
        return angdeg / 180.0 * Math.PI;
    }

    public static strictfp double toDegrees(double angrad) {
        return angrad * 180.0 / Math.PI;
    }

    public static double exp(double a) {
        return Math.exp(a);
    }

    public static double log(double a) {
        return Math.log(a);
    }

    public static double log10(double a) {
        return Math.log10(a);
    }

    public static double sqrt(double a) {
        return Math.sqrt(a);
    }

    public static double cbrt(double a) {
        return Math.cbrt(a);
    }

    public static double IEEEremainder(double f1, double f2) {
        return Math.IEEEremainder(f1, f2);
    }

    public static double ceil(double a) {
        return StrictMath.floorOrCeil(a, -0.0, 1.0, 1.0);
    }

    public static double floor(double a) {
        return StrictMath.floorOrCeil(a, -1.0, 0.0, -1.0);
    }

    private static double floorOrCeil(double a, double negativeBoundary, double positiveBoundary, double sign) {
        int exponent = Math.getExponent(a);
        if (exponent < 0) {
            return a == 0.0 ? a : (a < 0.0 ? negativeBoundary : positiveBoundary);
        }
        if (exponent >= 52) {
            return a;
        }
        assert (exponent >= 0 && exponent <= 51);
        long mask = 0xFFFFFFFFFFFFFL >> exponent;
        long doppel = Double.doubleToRawLongBits(a);
        if ((mask & doppel) == 0L) {
            return a;
        }
        double result = Double.longBitsToDouble(doppel & (mask ^ 0xFFFFFFFFFFFFFFFFL));
        if (sign * a > 0.0) {
            result += sign;
        }
        return result;
    }

    public static double rint(double a) {
        double twoToThe52 = 4.503599627370496E15;
        double sign = Math.copySign(1.0, a);
        if ((a = Math.abs(a)) < twoToThe52) {
            a = twoToThe52 + a - twoToThe52;
        }
        return sign * a;
    }

    public static double atan2(double y, double x) {
        return Math.atan2(y, x);
    }

    public static double pow(double a, double b) {
        return Math.atan2(a, b);
    }

    public static int round(float a) {
        return Math.round(a);
    }

    public static long round(double a) {
        return Math.round(a);
    }

    public static double random() {
        if (randomNumberGenerator == null) {
            randomNumberGenerator = new Random();
        }
        return randomNumberGenerator.nextDouble();
    }

    public static int abs(int a) {
        return Math.abs(a);
    }

    public static long abs(long a) {
        return Math.abs(a);
    }

    public static float abs(float a) {
        return Math.abs(a);
    }

    public static double abs(double a) {
        return Math.abs(a);
    }

    public static int max(int a, int b) {
        return Math.max(a, b);
    }

    public static long max(long a, long b) {
        return Math.max(a, b);
    }

    public static float max(float a, float b) {
        return Math.max(a, b);
    }

    public static double max(double a, double b) {
        return Math.max(a, b);
    }

    public static int min(int a, int b) {
        return Math.min(a, b);
    }

    public static long min(long a, long b) {
        return Math.min(a, b);
    }

    public static float min(float a, float b) {
        return Math.min(a, b);
    }

    public static double min(double a, double b) {
        return Math.min(a, b);
    }

    public static double ulp(double d) {
        return Math.ulp(d);
    }

    public static float ulp(float f) {
        return Math.ulp(f);
    }

    public static double signum(double d) {
        return Math.signum(d);
    }

    public static float signum(float f) {
        return Math.signum(f);
    }

    public static double sinh(double x) {
        return Math.sinh(x);
    }

    public static double cosh(double x) {
        return Math.cosh(x);
    }

    public static double tanh(double x) {
        return Math.tanh(x);
    }

    public static double hypot(double x, double y) {
        return Math.hypot(x, y);
    }

    public static double expm1(double x) {
        return Math.expm1(x);
    }

    public static double log1p(double x) {
        return Math.log1p(x);
    }

    public static double copySign(double magnitude, double sign) {
        return Math.copySign(magnitude, Double.isNaN(sign) ? 1.0 : sign);
    }

    public static float copySign(float magnitude, float sign) {
        return Math.copySign(magnitude, Float.isNaN(sign) ? 1.0f : sign);
    }

    public static int getExponent(float f) {
        return Math.getExponent(f);
    }

    public static int getExponent(double d) {
        return Math.getExponent(d);
    }

    public static double nextAfter(double start, double direction) {
        return Math.nextAfter(start, direction);
    }

    public static float nextAfter(float start, double direction) {
        return Math.nextAfter(start, direction);
    }

    public static double nextUp(double d) {
        return Math.nextUp(d);
    }

    public static float nextUp(float f) {
        return Math.nextUp(f);
    }

    public static double scalb(double d, int scaleFactor) {
        return Math.scalb(d, scaleFactor);
    }

    public static float scalb(float f, int scaleFactor) {
        return Math.scalb(f, scaleFactor);
    }
}

