/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import jtransc.annotation.JTranscKeep;
import jtransc.annotation.haxe.HaxeMethodBody;

public abstract class AbstractCollection<E>
implements Collection<E> {
    protected AbstractCollection() {
    }

    @Override
    @JTranscKeep
    public abstract Iterator<E> iterator();

    @Override
    public abstract int size();

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public native boolean contains(Object var1);

    @Override
    @JTranscKeep
    public Object[] toArray() {
        Object[] r = new Object[this.size()];
        int i = 0;
        for (E e : this) {
            r[i++] = e;
        }
        return r;
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.toArray();
    }

    @Override
    public boolean add(E e) {
        throw new UnsupportedOperationException();
    }

    @Override
    public native boolean remove(Object var1);

    @Override
    public boolean containsAll(Collection<?> collection) {
        HashSet set = new HashSet(this);
        for (Object item : collection) {
            if (set.contains(item)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean addAll(Collection<? extends E> collection) {
        boolean changed = false;
        for (E item : collection) {
            if (!this.add(item)) continue;
            changed = true;
        }
        return changed;
    }

    @Override
    public native boolean removeAll(Collection<?> var1);

    @Override
    public native boolean retainAll(Collection<?> var1);

    @Override
    public native void clear();

    @HaxeMethodBody(value="return HaxeNatives.str('[' + this.toArray___Ljava_lang_Object_().join(', ') + ']');")
    public native String toString();
}

