/*
 * Decompiled with CFR 0.152.
 */
package java.util.regex;

import java.util.regex.MatchResult;
import java.util.regex.Pattern;
import jtransc.annotation.haxe.HaxeAddMembers;
import jtransc.annotation.haxe.HaxeMethodBody;

@HaxeAddMembers(value={"public var _ereg:EReg;", "public var _matches:Bool;", "public var _offset:Int = 0;", "public var _matchPos:Int = 0;", "public var _matchLen:Int = 0;", "public function _find() {\n\tvar r = this._ereg;\n\tthis._matches = r.matchSub(this.text._str, this._offset);\n\tif (this._matches) {\n\t\tvar rpos = r.matchedPos();\n\t\tthis._matchPos = rpos.pos;\n\t\tthis._matchLen = rpos.len;\n\t\tthis._offset = rpos.pos + rpos.len;\n\t} else {\n\t\tthis._matchPos = 0;\n\t\tthis._matchLen = 0;\n\t}\n\treturn this._matches;\n}"})
public final class Matcher
implements MatchResult {
    private Pattern parent;
    private String pattern;
    private int flags;
    private String text;

    Matcher(Pattern parent, CharSequence text) {
        this.parent = parent;
        this.pattern = parent.pattern();
        this.flags = parent.flags();
        this.text = text.toString();
        this._init();
    }

    @HaxeMethodBody(value="var opts = '';\nif ((this.flags & 0x02) != 0) opts += 'i';\nif ((this.flags & 0x08) != 0) opts += 'm';\nif ((this.flags & 0x20) != 0) opts += 's';\nthis._ereg = new EReg(this.pattern._str, opts);\nthis._matches = this._ereg.match(this.text._str);")
    private void _init() {
    }

    public Pattern pattern() {
        return this.parent;
    }

    public MatchResult toMatchResult() {
        return this;
    }

    public native Matcher usePattern(Pattern var1);

    public native Matcher reset();

    public Matcher reset(CharSequence input) {
        this.text = input.toString();
        this.reset();
        return this;
    }

    @Override
    @HaxeMethodBody(value="return this._matchPos;")
    public native int start();

    @Override
    public int start(int group) {
        if (group == 0) {
            return this.start();
        }
        throw new Error("No implemented Matcher.start(int group) with group != 0");
    }

    public native int start(String var1);

    @Override
    @HaxeMethodBody(value="return this._matchPos + this._matchLen;")
    public native int end();

    @Override
    public int end(int group) {
        if (group == 0) {
            return this.end();
        }
        throw new Error("No implemented Matcher.end(int group) with group != 0");
    }

    public native int end(String var1);

    @Override
    @HaxeMethodBody(value="return HaxeNatives.str(this._ereg.matched(0));")
    public native String group();

    @Override
    @HaxeMethodBody(value="return HaxeNatives.str(this._ereg.matched(p0));")
    public native String group(int var1);

    public native String group(String var1);

    @Override
    public native int groupCount();

    @HaxeMethodBody(value="return this._matches;")
    public native boolean matches();

    @HaxeMethodBody(value="return _find();")
    public native boolean find();

    @HaxeMethodBody(value="this._offset = p0; return _find();")
    public native boolean find(int var1);

    public native boolean lookingAt();

    public static native String quoteReplacement(String var0);

    public native Matcher appendReplacement(StringBuffer var1, String var2);

    public native StringBuffer appendTail(StringBuffer var1);

    public native String replaceAll(String var1);

    public native String replaceFirst(String var1);

    public native Matcher region(int var1, int var2);

    public native int regionStart();

    public native int regionEnd();

    public native boolean hasTransparentBounds();

    public native Matcher useTransparentBounds(boolean var1);

    public native boolean hasAnchoringBounds();

    public native Matcher useAnchoringBounds(boolean var1);

    public native String toString();

    public native boolean hitEnd();

    public native boolean requireEnd();
}

