/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class BufferedOutputStream
extends FilterOutputStream {
    protected byte[] buf;
    protected int count;

    public BufferedOutputStream(OutputStream out) {
        this(out, 8192);
    }

    public BufferedOutputStream(OutputStream out, int size) {
        super(out);
        this.buf = new byte[size];
    }

    @Override
    public synchronized void write(int value) throws IOException {
        if (this.count >= this.buf.length) {
            this.flushbuf();
        }
        this.buf[this.count++] = (byte)value;
    }

    @Override
    public synchronized void write(byte[] value, int offset, int length) throws IOException {
        if (length >= this.buf.length) {
            this.flushbuf();
            this.out.write(value, offset, length);
            return;
        }
        if (length > this.buf.length - this.count) {
            this.flushbuf();
        }
        System.arraycopy(value, offset, this.buf, this.count, length);
        this.count += length;
    }

    @Override
    public synchronized void flush() throws IOException {
        this.flushbuf();
        this.out.flush();
    }

    private void flushbuf() throws IOException {
        if (this.count <= 0) {
            return;
        }
        this.out.write(this.buf, 0, this.count);
        this.count = 0;
    }
}

