/*
 * Decompiled with CFR 0.152.
 */
package java.lang.reflect;

import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Member;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.lang.reflect._InternalUtils;
import jtransc.annotation.haxe.HaxeAddMembers;
import jtransc.annotation.haxe.HaxeMethodBody;

@HaxeAddMembers(value={"public var _internalName = '';", "public var _annotations = [];"})
public final class Field
extends AccessibleObject
implements Member {
    private Class<?> clazz;
    private String name;
    protected int modifiers;
    private int slot;
    private transient String signature;
    private transient String genericSignature;
    private byte[] annotations;
    private Type genericType;

    @Override
    @HaxeMethodBody(value="return HaxeArray.fromArray(_annotations, '[Ljava.lang.Annotation;');")
    public native Annotation[] getDeclaredAnnotations();

    private Field() {
    }

    @Override
    public Class<?> getDeclaringClass() {
        return this.clazz;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public int getModifiers() {
        return this.modifiers;
    }

    public boolean isEnumConstant() {
        return (this.getModifiers() & 0x4000) != 0;
    }

    @Override
    public boolean isSynthetic() {
        return (this.getModifiers() & 0x1000) != 0;
    }

    public Class<?> getType() {
        try {
            return Class.forName(this.signature);
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
            return null;
        }
    }

    public Type getGenericType() {
        if (this.genericType == null) {
            this.genericType = this.genericSignature != null ? _InternalUtils.parseType(this.genericSignature, null) : this.getType();
        }
        return this.genericType;
    }

    public boolean equals(Object obj) {
        if (obj != null && obj instanceof Field) {
            Field other = (Field)obj;
            return this.getDeclaringClass() == other.getDeclaringClass() && this.getName().equals(other.getName()) && this.getType() == other.getType();
        }
        return false;
    }

    public int hashCode() {
        return this.getDeclaringClass().getName().hashCode() ^ this.getName().hashCode();
    }

    public String toString() {
        int mod = this.getModifiers();
        return (mod == 0 ? "" : Modifier.toString(mod) + " ") + _InternalUtils.getTypeName(this.getType()) + " " + _InternalUtils.getTypeName(this.getDeclaringClass()) + "." + this.getName();
    }

    @HaxeMethodBody(value="return HaxeNatives.getField(this.clazz._hxClass, p0, this._internalName);")
    public native Object get(Object var1) throws IllegalArgumentException, IllegalAccessException;

    public native boolean getBoolean(Object var1) throws IllegalArgumentException, IllegalAccessException;

    public native byte getByte(Object var1) throws IllegalArgumentException, IllegalAccessException;

    public native char getChar(Object var1) throws IllegalArgumentException, IllegalAccessException;

    public native short getShort(Object var1) throws IllegalArgumentException, IllegalAccessException;

    public native int getInt(Object var1) throws IllegalArgumentException, IllegalAccessException;

    public native long getLong(Object var1) throws IllegalArgumentException, IllegalAccessException;

    public native float getFloat(Object var1) throws IllegalArgumentException, IllegalAccessException;

    public native double getDouble(Object var1) throws IllegalArgumentException, IllegalAccessException;

    @HaxeMethodBody(value="Reflect.setField(p0, this._internalName, p1);")
    public native void set(Object var1, Object var2) throws IllegalArgumentException, IllegalAccessException;

    public native void setBoolean(Object var1, boolean var2) throws IllegalArgumentException, IllegalAccessException;

    public native void setByte(Object var1, byte var2) throws IllegalArgumentException, IllegalAccessException;

    public native void setChar(Object var1, char var2) throws IllegalArgumentException, IllegalAccessException;

    public native void setShort(Object var1, short var2) throws IllegalArgumentException, IllegalAccessException;

    public native void setInt(Object var1, int var2) throws IllegalArgumentException, IllegalAccessException;

    public native void setLong(Object var1, long var2) throws IllegalArgumentException, IllegalAccessException;

    public native void setFloat(Object var1, float var2) throws IllegalArgumentException, IllegalAccessException;

    public native void setDouble(Object var1, double var2) throws IllegalArgumentException, IllegalAccessException;

    @Override
    public <T extends Annotation> T getAnnotation(Class<T> annotationClass) {
        return super.getAnnotation(annotationClass);
    }
}

