/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.Objects;

public abstract class Enum<E extends Enum<E>>
implements Comparable<E>,
Serializable {
    private final String name;
    private final int ordinal;

    public final String name() {
        return this.name;
    }

    public final int ordinal() {
        return this.ordinal;
    }

    protected Enum(String name, int ordinal) {
        this.name = name;
        this.ordinal = ordinal;
    }

    public String toString() {
        return this.name;
    }

    public final boolean equals(Object other) {
        return this == other;
    }

    public final int hashCode() {
        return super.hashCode();
    }

    protected final Object clone() throws CloneNotSupportedException {
        throw new CloneNotSupportedException();
    }

    @Override
    public final int compareTo(E o) {
        E other = o;
        Enum self = this;
        if (self.getClass() != other.getClass() && self.getDeclaringClass() != ((Enum)other).getDeclaringClass()) {
            throw new ClassCastException();
        }
        return self.ordinal - ((Enum)other).ordinal;
    }

    public final Class<E> getDeclaringClass() {
        Class<?> clazz = this.getClass();
        Class<?> zuper = clazz.getSuperclass();
        return zuper == Enum.class ? clazz : zuper;
    }

    public static <T extends Enum<T>> T valueOf(Class<T> enumType, String name) {
        for (Field field : enumType.getDeclaredFields()) {
            if (!Objects.equals(field.getName(), name)) continue;
            try {
                return (T)((Enum)field.get(null));
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    protected final void finalize() {
    }
}

