/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import java.io.IOException;
import java.io.InputStream;

public class ByteArrayInputStream
extends InputStream {
    protected byte[] buf;
    protected int pos;
    protected int mark = 0;
    protected int count;

    public ByteArrayInputStream(byte[] data) {
        this.buf = data;
        this.pos = 0;
        this.count = data.length;
    }

    public ByteArrayInputStream(byte[] data, int offset, int length) {
        this.buf = data;
        this.pos = offset;
        this.count = Math.min(offset + length, data.length);
        this.mark = offset;
    }

    @Override
    public synchronized int read() {
        return this.pos < this.count ? this.buf[this.pos++] & 0xFF : -1;
    }

    @Override
    public synchronized int read(byte[] data, int offset, int length) {
        if (data == null) {
            throw new NullPointerException();
        }
        if (offset < 0 || length < 0 || length > data.length - offset) {
            throw new IndexOutOfBoundsException();
        }
        if (this.pos >= this.count) {
            return -1;
        }
        int avail = this.count - this.pos;
        if (length > avail) {
            length = avail;
        }
        if (length <= 0) {
            return 0;
        }
        System.arraycopy(this.buf, this.pos, data, offset, length);
        this.pos += length;
        return length;
    }

    @Override
    public synchronized long skip(long n) {
        long left = this.count - this.pos;
        if (n < left) {
            left = n < 0L ? 0L : n;
        }
        this.pos = (int)((long)this.pos + left);
        return left;
    }

    @Override
    public synchronized int available() {
        return this.count - this.pos;
    }

    @Override
    public boolean markSupported() {
        return true;
    }

    @Override
    public void mark(int readAheadLimit) {
        this.mark = this.pos;
    }

    @Override
    public synchronized void reset() {
        this.pos = this.mark;
    }

    @Override
    public void close() throws IOException {
    }
}

