/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import java.io.File;
import java.io.FileDescriptor;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import jtransc.internal.JTranscIOSync;
import jtransc.internal.JTranscIOSyncFile;

public class FileOutputStream
extends OutputStream {
    private final FileDescriptor fd;
    private final boolean append;
    private final String path;
    private final JTranscIOSyncFile jfd;
    private volatile boolean closed = false;

    public FileOutputStream(String name) throws FileNotFoundException {
        this(name != null ? new File(name) : null, false);
    }

    public FileOutputStream(String name, boolean append) throws FileNotFoundException {
        this(name != null ? new File(name) : null, append);
    }

    public FileOutputStream(File file) throws FileNotFoundException {
        this(file, false);
    }

    public FileOutputStream(File file, boolean append) throws FileNotFoundException {
        String name;
        String string = name = file != null ? file.getPath() : null;
        if (name == null) {
            throw new NullPointerException();
        }
        if (file.isInvalid()) {
            throw new FileNotFoundException("Invalid file path");
        }
        this.fd = new FileDescriptor();
        this.append = append;
        this.path = name;
        this.jfd = JTranscIOSync.open(name, 2);
        try {
            if (append) {
                this.jfd.seek(this.jfd.length());
            }
        }
        catch (IOException e) {
            // empty catch block
        }
    }

    public FileOutputStream(FileDescriptor fdObj) {
        throw new RuntimeException("Not implemented");
    }

    @Override
    public void write(int b) throws IOException {
        this.jfd.write(b);
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.jfd.writeBytes(b, 0, b.length);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        this.jfd.writeBytes(b, off, len);
    }

    @Override
    public void close() throws IOException {
        if (this.closed) {
            return;
        }
        this.closed = true;
        this.jfd.close();
    }

    public final FileDescriptor getFD() throws IOException {
        if (this.fd != null) {
            return this.fd;
        }
        throw new IOException();
    }

    protected void finalize() throws IOException {
        if (this.fd == null) {
            return;
        }
        if (this.fd == FileDescriptor.out || this.fd == FileDescriptor.err) {
            this.flush();
        } else {
            this.close();
        }
    }
}

