/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.io.Serializable;
import java.util.AbstractList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Objects;
import java.util.RandomAccess;
import jtransc.annotation.haxe.HaxeAddMembers;
import jtransc.annotation.haxe.HaxeMethodBody;
import jtransc.internal.GenericListIterator;

@HaxeAddMembers(value={"var _data:Array<Dynamic> = [];"})
public class ArrayList<E>
extends AbstractList<E>
implements List<E>,
RandomAccess,
Cloneable,
Serializable {
    public ArrayList(int initialCapacity) {
    }

    public ArrayList() {
    }

    public ArrayList(Collection<? extends E> c) {
        this.addAll(c);
    }

    public void trimToSize() {
    }

    public void ensureCapacity(int minCapacity) {
    }

    @Override
    @HaxeMethodBody(value="return _data.length;")
    public native int size();

    @HaxeMethodBody(value="return _data[p0];")
    private native E _get(int var1);

    @HaxeMethodBody(value="_data[p0] = p1;")
    private native void _set(int var1, E var2);

    @HaxeMethodBody(value="_data = _data.slice(0, p0);")
    private native void _setLength(int var1);

    @HaxeMethodBody(value="_data.push(p0);")
    private native void _add(E var1);

    @HaxeMethodBody(value="_data.insert(p0, p1);")
    private native void _insert(int var1, E var2);

    @HaxeMethodBody(value="_data = _data.slice(0, p0).concat(p1.toArray()).concat(_data.slice(p0));")
    private native void _insert(int var1, Object[] var2);

    @HaxeMethodBody(value="_data = _data.slice(0, p0).concat(_data.slice(p0));")
    private native void _remove(int var1, int var2);

    @HaxeMethodBody(value="_data.splice(p0, 1);")
    private native void _remove(int var1);

    @HaxeMethodBody(value="_data = [];")
    private native void _clear();

    @HaxeMethodBody(value="p0._data = p1._data.slice(0);")
    private static native void _copy(ArrayList<?> var0, ArrayList<?> var1);

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public boolean contains(Object o) {
        return this.indexOf(o) >= 0;
    }

    @Override
    public int indexOf(Object o) {
        int len = this.size();
        for (int i = 0; i < len; ++i) {
            if (!Objects.equals(o, this._get(i))) continue;
            return i;
        }
        return -1;
    }

    @Override
    public int lastIndexOf(Object o) {
        int len = this.size();
        for (int i = len - 1; i >= 0; --i) {
            if (!Objects.equals(o, this._get(i))) continue;
            return i;
        }
        return -1;
    }

    public Object clone() {
        try {
            ArrayList v = (ArrayList)super.clone();
            ArrayList._copy(v, this);
            v.modCount = 0;
            return v;
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError(e);
        }
    }

    @Override
    public Object[] toArray() {
        return this.toArray(new Object[this.size()]);
    }

    @Override
    public <T> T[] toArray(T[] a) {
        int len = this.size();
        if (a.length < len) {
            a = Arrays.copyOf(new Object[0], len, a.getClass());
        }
        for (int n = 0; n < len; ++n) {
            a[n] = this._get(n);
        }
        return a;
    }

    @Override
    public E get(int index) {
        this.rangeCheck(index);
        return this._get(index);
    }

    @Override
    public E set(int index, E element) {
        this.rangeCheck(index);
        E oldValue = this._get(index);
        this._set(index, element);
        return oldValue;
    }

    @Override
    public boolean add(E e) {
        this._add(e);
        return true;
    }

    @Override
    public void add(int index, E element) {
        this.rangeCheckForAdd(index);
        this._insert(index, element);
    }

    @Override
    public E remove(int index) {
        this.rangeCheck(index);
        ++this.modCount;
        E oldValue = this._get(index);
        this._remove(index);
        return oldValue;
    }

    @Override
    public boolean remove(Object o) {
        int len = this.size();
        for (int index = 0; index < len; ++index) {
            if (!Objects.equals(o, this._get(index))) continue;
            this._remove(index);
            return true;
        }
        return false;
    }

    @Override
    public void clear() {
        ++this.modCount;
        this._clear();
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        for (E e : c) {
            this.add(e);
        }
        return c.size() != 0;
    }

    @Override
    public boolean addAll(int index, Collection<? extends E> c) {
        this.rangeCheckForAdd(index);
        this._insert(index, c.toArray());
        if (c.size() != 0) {
            ++this.modCount;
        }
        return c.size() != 0;
    }

    @Override
    protected void removeRange(int fromIndex, int toIndex) {
        ++this.modCount;
        this._remove(fromIndex, toIndex);
    }

    private void rangeCheck(int index) {
        if (index >= this.size()) {
            throw new IndexOutOfBoundsException(this.outOfBoundsMsg(index));
        }
    }

    private void rangeCheckForAdd(int index) {
        if (index > this.size() || index < 0) {
            throw new IndexOutOfBoundsException(this.outOfBoundsMsg(index));
        }
    }

    private String outOfBoundsMsg(int index) {
        return "Index: " + index + ", Size: " + this.size();
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        Objects.requireNonNull(c);
        return this.batchRemove(c, false);
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        Objects.requireNonNull(c);
        return this.batchRemove(c, true);
    }

    private boolean batchRemove(Collection<?> c, boolean complement) {
        int r;
        int w = 0;
        for (r = 0; r < this.size(); ++r) {
            if (c.contains(this._get(r)) != complement) continue;
            this._set(w++, this._get(r));
        }
        this._setLength(w);
        return r != w;
    }

    @Override
    public ListIterator<E> listIterator(int index) {
        if (index < 0 || index > this.size()) {
            throw new IndexOutOfBoundsException("Index: " + index);
        }
        return new GenericListIterator(this, index);
    }

    @Override
    public ListIterator<E> listIterator() {
        return this.listIterator(0);
    }

    @Override
    public Iterator<E> iterator() {
        return this.listIterator();
    }

    @Override
    public List<E> subList(int fromIndex, int toIndex) {
        return super.subList(fromIndex, toIndex);
    }
}

