/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import jtransc.annotation.JTranscKeep;
import jtransc.annotation.haxe.HaxeMethodBody;

public final class Short
extends Number
implements Comparable<Short> {
    public static final int SIZE = 16;
    public static final int BYTES = 2;
    public static final short MIN_VALUE = Short.MIN_VALUE;
    public static final short MAX_VALUE = Short.MAX_VALUE;
    public static final Class<Short> TYPE = Class.getPrimitiveClass("short");
    private final short value;

    public static String toString(short s) {
        return Integer.toString(s, 10);
    }

    private static int checkDecode(String value, int decoded) throws NumberFormatException {
        if (decoded < Short.MIN_VALUE || decoded > Short.MAX_VALUE) {
            throw new NumberFormatException("Value " + decoded + " out of range from input " + value);
        }
        return decoded;
    }

    public static short parseShort(String s, int radix) throws NumberFormatException {
        return (short)Short.checkDecode(s, Integer.parseInt(s, radix));
    }

    public static short parseShort(String s) throws NumberFormatException {
        return Short.parseShort(s, 10);
    }

    public static Short valueOf(String s, int radix) throws NumberFormatException {
        return Short.parseShort(s, radix);
    }

    public static Short valueOf(String s) throws NumberFormatException {
        return Short.parseShort(s, 10);
    }

    @JTranscKeep
    public static Short valueOf(short s) {
        return new Short(s);
    }

    public static Short decode(String nm) throws NumberFormatException {
        return (byte)Short.checkDecode(nm, Integer.decode(nm));
    }

    public Short(short value) {
        this.value = value;
    }

    public Short(String s) throws NumberFormatException {
        this.value = Short.parseShort(s, 10);
    }

    @Override
    public byte byteValue() {
        return (byte)this.value;
    }

    @Override
    public short shortValue() {
        return this.value;
    }

    @Override
    public int intValue() {
        return this.value;
    }

    @Override
    public long longValue() {
        return this.value;
    }

    @Override
    public float floatValue() {
        return this.value;
    }

    @Override
    public double doubleValue() {
        return this.value;
    }

    public String toString() {
        return Integer.toString(this.value);
    }

    public int hashCode() {
        return Short.hashCode(this.value);
    }

    public static int hashCode(short value) {
        return value;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Short)) {
            return false;
        }
        return this.value == (Short)obj;
    }

    @Override
    public int compareTo(Short anotherShort) {
        return Short.compare(this.value, anotherShort.value);
    }

    public static int compare(short x, short y) {
        return x - y;
    }

    @HaxeMethodBody(value="return HaxeNatives.swap16(p0);")
    public static short reverseBytes(short value) {
        return (short)((value & 0xFF00) >> 8 | (value & 0xFF) << 8);
    }

    public static int toUnsignedInt(short value) {
        return value & 0xFFFF;
    }

    public static long toUnsignedLong(short value) {
        return (long)value & 0xFFFFL;
    }
}

